/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.portlet;

import com.liferay.portal.kernel.monitoring.DataSample;
import com.liferay.portal.kernel.monitoring.DataSampleFactory;
import com.liferay.portal.kernel.monitoring.DataSampleThreadLocal;
import com.liferay.portal.kernel.monitoring.PortletRequestType;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.portlet.InvokerFilterContainer;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration;
import jakarta.portlet.ActionRequest;
import jakarta.portlet.ActionResponse;
import jakarta.portlet.EventRequest;
import jakarta.portlet.EventResponse;
import jakarta.portlet.HeaderRequest;
import jakarta.portlet.HeaderResponse;
import jakarta.portlet.MimeResponse;
import jakarta.portlet.Portlet;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletContext;
import jakarta.portlet.PortletException;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.portlet.RenderRequest;
import jakarta.portlet.RenderResponse;
import jakarta.portlet.ResourceRequest;
import jakarta.portlet.ResourceResponse;
import jakarta.portlet.filter.ActionFilter;
import jakarta.portlet.filter.EventFilter;
import jakarta.portlet.filter.HeaderFilter;
import jakarta.portlet.filter.RenderFilter;
import jakarta.portlet.filter.ResourceFilter;
import java.io.IOException;
import java.util.List;

public class MonitoringInvokerPortlet
implements InvokerFilterContainer,
InvokerPortlet {
    private long _actionTimeout;
    private final DataSampleFactory _dataSampleFactory;
    private long _headerTimeout;
    private InvokerPortlet _invokerPortlet;
    private final MonitoringConfiguration _monitoringConfiguration;
    private long _renderTimeout;

    public MonitoringInvokerPortlet(DataSampleFactory dataSampleFactory, InvokerPortlet invokerPortlet, MonitoringConfiguration monitoringConfiguration) {
        this._dataSampleFactory = dataSampleFactory;
        this._invokerPortlet = invokerPortlet;
        this._monitoringConfiguration = monitoringConfiguration;
    }

    public void destroy() {
        this._invokerPortlet.destroy();
    }

    public List<ActionFilter> getActionFilters() {
        InvokerFilterContainer invokerFilterContainer = (InvokerFilterContainer)this._invokerPortlet;
        return invokerFilterContainer.getActionFilters();
    }

    public List<EventFilter> getEventFilters() {
        InvokerFilterContainer invokerFilterContainer = (InvokerFilterContainer)this._invokerPortlet;
        return invokerFilterContainer.getEventFilters();
    }

    public Integer getExpCache() {
        return this._invokerPortlet.getExpCache();
    }

    public List<HeaderFilter> getHeaderFilters() {
        InvokerFilterContainer invokerFilterContainer = (InvokerFilterContainer)this._invokerPortlet;
        return invokerFilterContainer.getHeaderFilters();
    }

    public Portlet getPortlet() {
        return this._invokerPortlet.getPortlet();
    }

    public ClassLoader getPortletClassLoader() {
        return this._invokerPortlet.getPortletClassLoader();
    }

    public PortletConfig getPortletConfig() {
        return this._invokerPortlet.getPortletConfig();
    }

    public PortletContext getPortletContext() {
        return this._invokerPortlet.getPortletContext();
    }

    public Portlet getPortletInstance() {
        return this._invokerPortlet.getPortletInstance();
    }

    public List<RenderFilter> getRenderFilters() {
        InvokerFilterContainer invokerFilterContainer = (InvokerFilterContainer)this._invokerPortlet;
        return invokerFilterContainer.getRenderFilters();
    }

    public List<ResourceFilter> getResourceFilters() {
        InvokerFilterContainer invokerFilterContainer = (InvokerFilterContainer)this._invokerPortlet;
        return invokerFilterContainer.getResourceFilters();
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        this._invokerPortlet.init((PortletConfig)liferayPortletConfig);
        com.liferay.portal.kernel.model.Portlet portletModel = liferayPortletConfig.getPortlet();
        this._actionTimeout = portletModel.getActionTimeout();
        this._headerTimeout = portletModel.getHeaderTimeout();
        this._renderTimeout = portletModel.getRenderTimeout();
    }

    public boolean isCheckAuthToken() {
        return this._invokerPortlet.isCheckAuthToken();
    }

    public boolean isFacesPortlet() {
        return this._invokerPortlet.isFacesPortlet();
    }

    public boolean isHeaderPortlet() {
        return this._invokerPortlet.isHeaderPortlet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        DataSample dataSample = null;
        try {
            if (this._monitoringConfiguration.monitorPortletActionRequest()) {
                dataSample = this._dataSampleFactory.createPortletRequestDataSample(PortletRequestType.ACTION, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
                dataSample.setTimeout(this._actionTimeout);
                dataSample.prepare();
                DataSampleThreadLocal.initialize();
            }
            this._invokerPortlet.processAction(actionRequest, actionResponse);
            if (this._monitoringConfiguration.monitorPortletActionRequest() && dataSample != null) {
                dataSample.capture(RequestStatus.SUCCESS);
            }
            if (dataSample == null) return;
        }
        catch (Exception exception) {
            try {
                this._processException(this._monitoringConfiguration.monitorPortletActionRequest(), dataSample, exception);
                if (dataSample == null) return;
            }
            catch (Throwable throwable) {
                if (dataSample == null) throw throwable;
                DataSampleThreadLocal.addDataSample(dataSample);
                throw throwable;
            }
            DataSampleThreadLocal.addDataSample((DataSample)dataSample);
            return;
        }
        DataSampleThreadLocal.addDataSample((DataSample)dataSample);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        DataSample dataSample = null;
        try {
            if (this._monitoringConfiguration.monitorPortletEventRequest()) {
                dataSample = this._dataSampleFactory.createPortletRequestDataSample(PortletRequestType.EVENT, (PortletRequest)eventRequest, (PortletResponse)eventResponse);
                dataSample.prepare();
                DataSampleThreadLocal.initialize();
            }
            this._invokerPortlet.processEvent(eventRequest, eventResponse);
            if (this._monitoringConfiguration.monitorPortletEventRequest() && dataSample != null) {
                dataSample.capture(RequestStatus.SUCCESS);
            }
            if (dataSample == null) return;
        }
        catch (Exception exception) {
            try {
                this._processException(this._monitoringConfiguration.monitorPortletEventRequest(), dataSample, exception);
                if (dataSample == null) return;
            }
            catch (Throwable throwable) {
                if (dataSample == null) throw throwable;
                DataSampleThreadLocal.addDataSample(dataSample);
                throw throwable;
            }
            DataSampleThreadLocal.addDataSample((DataSample)dataSample);
            return;
        }
        DataSampleThreadLocal.addDataSample((DataSample)dataSample);
        return;
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this._render(renderRequest, (MimeResponse)renderResponse, () -> this._invokerPortlet.render(renderRequest, renderResponse), PortletRequestType.RENDER, this._renderTimeout);
    }

    public void renderHeaders(HeaderRequest headerRequest, HeaderResponse headerResponse) throws IOException, PortletException {
        this._render((RenderRequest)headerRequest, (MimeResponse)headerResponse, () -> this._invokerPortlet.renderHeaders(headerRequest, headerResponse), PortletRequestType.HEADER, this._headerTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        DataSample dataSample = null;
        try {
            if (this._monitoringConfiguration.monitorPortletResourceRequest()) {
                dataSample = this._dataSampleFactory.createPortletRequestDataSample(PortletRequestType.RESOURCE, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
                dataSample.prepare();
                DataSampleThreadLocal.initialize();
            }
            this._invokerPortlet.serveResource(resourceRequest, resourceResponse);
            if (this._monitoringConfiguration.monitorPortletResourceRequest() && dataSample != null) {
                dataSample.capture(RequestStatus.SUCCESS);
            }
            if (dataSample == null) return;
        }
        catch (Exception exception) {
            try {
                this._processException(this._monitoringConfiguration.monitorPortletResourceRequest(), dataSample, exception);
                if (dataSample == null) return;
            }
            catch (Throwable throwable) {
                if (dataSample == null) throw throwable;
                DataSampleThreadLocal.addDataSample(dataSample);
                throw throwable;
            }
            DataSampleThreadLocal.addDataSample((DataSample)dataSample);
            return;
        }
        DataSampleThreadLocal.addDataSample((DataSample)dataSample);
        return;
    }

    public void setInvokerPortlet(InvokerPortlet invokerPortlet) {
        this._invokerPortlet = invokerPortlet;
    }

    public void setPortletFilters() throws PortletException {
        this._invokerPortlet.setPortletFilters();
    }

    private void _processException(boolean monitorPortletRequest, DataSample dataSample, Exception exception) throws IOException, PortletException {
        if (monitorPortletRequest && dataSample != null) {
            dataSample.capture(RequestStatus.ERROR);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof PortletException) {
            throw (PortletException)exception;
        }
        throw new PortletException("Unable to process portlet", (Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _render(RenderRequest renderRequest, MimeResponse mimeResponse, Renderable renderable, PortletRequestType portletRequestType, long timeout) throws IOException, PortletException {
        DataSample dataSample = null;
        try {
            if (this._monitoringConfiguration.monitorPortletHeaderRequest() || this._monitoringConfiguration.monitorPortletRenderRequest()) {
                dataSample = this._dataSampleFactory.createPortletRequestDataSample(portletRequestType, (PortletRequest)renderRequest, (PortletResponse)mimeResponse);
                dataSample.setTimeout(timeout);
                dataSample.prepare();
                DataSampleThreadLocal.initialize();
            }
            renderable.render();
            if ((this._monitoringConfiguration.monitorPortletHeaderRequest() || this._monitoringConfiguration.monitorPortletRenderRequest()) && dataSample != null) {
                dataSample.capture(RequestStatus.SUCCESS);
            }
            if (dataSample == null) return;
        }
        catch (Exception exception) {
            try {
                this._processException(this._monitoringConfiguration.monitorPortletHeaderRequest() || this._monitoringConfiguration.monitorPortletRenderRequest(), dataSample, exception);
                if (dataSample == null) return;
            }
            catch (Throwable throwable) {
                if (dataSample == null) throw throwable;
                DataSampleThreadLocal.addDataSample(dataSample);
                throw throwable;
            }
            DataSampleThreadLocal.addDataSample((DataSample)dataSample);
            return;
        }
        DataSampleThreadLocal.addDataSample((DataSample)dataSample);
        return;
    }

    @FunctionalInterface
    private static interface Renderable {
        public void render() throws IOException, PortletException;
    }
}

