/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.messaging;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration;
import java.util.Dictionary;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration"}, enabled=false, service={})
public class MonitoringMessagingConfigurator {
    private static final Log _log = LogFactoryUtil.getLog(MonitoringMessagingConfigurator.class);
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _serviceRegistration;

    @Activate
    protected void activate(ComponentContext componentContext) {
        BundleContext bundleContext = componentContext.getBundleContext();
        MonitoringConfiguration monitoringConfiguration = (MonitoringConfiguration)ConfigurableUtil.createConfigurable(MonitoringConfiguration.class, (Dictionary)componentContext.getProperties());
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "liferay/monitoring");
        destinationConfiguration.setMaximumQueueSize(monitoringConfiguration.monitoringMessageMaxQueueSize());
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"The current thread will handle the request because the monitoring destination's task queue is at its maximum capacity");
                }
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        };
        destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary destinationProperties = HashMapDictionaryBuilder.put((Object)"destination.name", (Object)destination.getName()).build();
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)destinationProperties);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }
}

