/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.messaging;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.monitoring.DataSample;
import com.liferay.portal.kernel.monitoring.DataSampleProcessor;
import com.liferay.portal.kernel.monitoring.Level;
import com.liferay.portal.kernel.monitoring.MonitoringControl;
import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"destination.name=liferay/monitoring"}, service={MessageListener.class})
public class MonitoringMessageListener
extends BaseMessageListener {
    @Reference
    private MonitoringControl _monitoringControl;
    private ServiceTrackerMap<String, List<DataSampleProcessor<DataSample>>> _serviceTrackerMap;

    public void processDataSample(DataSample dataSample) throws MonitoringException {
        String namespace = dataSample.getNamespace();
        Level level = this._monitoringControl.getLevel(namespace);
        if (level != null && level.equals((Object)Level.OFF)) {
            return;
        }
        List dataSampleProcessors = (List)this._serviceTrackerMap.getService((Object)namespace);
        if (ListUtil.isEmpty((List)dataSampleProcessors)) {
            return;
        }
        for (DataSampleProcessor dataSampleProcessor : dataSampleProcessors) {
            dataSampleProcessor.processDataSample(dataSample);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, DataSampleProcessor.class, (String)"namespace");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected void doReceive(Message message) throws Exception {
        List dataSamples = (List)message.getPayload();
        if (ListUtil.isNotEmpty((List)dataSamples)) {
            for (DataSample dataSample : dataSamples) {
                this.processDataSample(dataSample);
            }
        }
    }
}

