/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.aop;

import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.monitoring.DataSample;
import com.liferay.portal.kernel.monitoring.DataSampleFactory;
import com.liferay.portal.kernel.monitoring.DataSampleThreadLocal;
import com.liferay.portal.kernel.monitoring.MethodSignature;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.monitoring.ServiceMonitoringControl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;

public class ServiceMonitorAdvice
extends ChainableMethodAdvice {
    private final DataSampleFactory _dataSampleFactory;
    private final ServiceMonitoringControl _serviceMonitoringControl;

    public ServiceMonitorAdvice(ServiceMonitoringControl serviceMonitoringControl, DataSampleFactory dataSampleFactory) {
        this._serviceMonitoringControl = serviceMonitoringControl;
        this._dataSampleFactory = dataSampleFactory;
    }

    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        return new MethodSignature(method);
    }

    public Object invoke(AopMethodInvocation aopMethodInvocation, Object[] arguments) throws Throwable {
        boolean included = false;
        Method method = aopMethodInvocation.getMethod();
        Class<?> declaringClass = method.getDeclaringClass();
        MethodSignature methodSignature = (MethodSignature)aopMethodInvocation.getAdviceMethodContext();
        Set serviceClasses = this._serviceMonitoringControl.getServiceClasses();
        Set serviceClassMethods = this._serviceMonitoringControl.getServiceClassMethods();
        if (serviceClasses.contains(declaringClass.getName()) || serviceClassMethods.contains(methodSignature)) {
            included = true;
        }
        if (this._serviceMonitoringControl.isInclusiveMode() != included) {
            return aopMethodInvocation.proceed(arguments);
        }
        DataSample dataSample = this._dataSampleFactory.createServiceRequestDataSample(methodSignature);
        dataSample.prepare();
        DataSampleThreadLocal.initialize();
        try {
            Object returnValue = aopMethodInvocation.proceed(arguments);
            dataSample.capture(RequestStatus.SUCCESS);
            Object object = returnValue;
            return object;
        }
        catch (Throwable throwable) {
            dataSample.capture(RequestStatus.ERROR);
            throw throwable;
        }
        finally {
            DataSampleThreadLocal.addDataSample((DataSample)dataSample);
        }
    }
}

