/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.monitoring.Level;
import com.liferay.portal.kernel.monitoring.MonitoringControl;
import com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component(configurationPid={"com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration"}, service={MonitoringControl.class})
public class MonitoringControlImpl
implements MonitoringControl {
    private static final Log _log = LogFactoryUtil.getLog(MonitoringControlImpl.class);
    private volatile ComponentContext _componentContext;
    private final AtomicBoolean _enabled = new AtomicBoolean();
    private final Map<String, Level> _levels = new ConcurrentHashMap<String, Level>();
    private volatile MonitoringConfiguration _monitoringConfiguration;

    public Level getLevel(String namespace) {
        Level level = this._levels.get(namespace);
        if (level == null) {
            return Level.OFF;
        }
        return level;
    }

    public Set<String> getNamespaces() {
        return this._levels.keySet();
    }

    public void setLevel(String namespace, Level level) {
        if (level == Level.OFF) {
            this._levels.remove(namespace);
        } else {
            this._levels.put(namespace, level);
        }
        this._refreshComponents(this._monitoringConfiguration.monitorEnabled() && !this._levels.isEmpty());
    }

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) throws Exception {
        this._componentContext = componentContext;
        this._monitoringConfiguration = (MonitoringConfiguration)ConfigurableUtil.createConfigurable(MonitoringConfiguration.class, properties);
        this._refreshComponents(this._monitoringConfiguration.monitorEnabled() && !this._levels.isEmpty());
    }

    private List<String> _loadGateKeptServices(Bundle bundle) throws Exception {
        ArrayList<String> services = new ArrayList<String>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Enumeration enumeration = bundle.findEntries("/OSGI-INF", "*.xml", false);
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            InputStream inputStream = url.openStream();
            try {
                Document document = documentBuilder.parse(inputStream);
                Element element = document.getDocumentElement();
                String enabled = element.getAttribute("enabled");
                if (enabled.isEmpty() || Boolean.valueOf(enabled).booleanValue()) continue;
                services.add(element.getAttribute("name"));
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return services;
    }

    private void _refreshComponents(boolean enabled) {
        if (this._enabled.getAndSet(enabled) == enabled) {
            return;
        }
        BundleContext bundleContext = this._componentContext.getBundleContext();
        try {
            List<String> services = this._loadGateKeptServices(bundleContext.getBundle());
            if (enabled) {
                for (String service : services) {
                    this._componentContext.enableComponent(service);
                }
            } else {
                for (String service : services) {
                    this._componentContext.disableComponent(service);
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to refresh components", (Throwable)exception);
        }
    }
}

