/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component(configurationPid={"com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration"}, immediate=true, service={})
public class MonitoringGateKeeper {
    @Activate
    @Modified
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) throws Exception {
        BundleContext bundleContext = componentContext.getBundleContext();
        List<String> services = this._loadGateKeptServices(bundleContext.getBundle());
        MonitoringConfiguration monitoringConfiguration = (MonitoringConfiguration)ConfigurableUtil.createConfigurable(MonitoringConfiguration.class, properties);
        if (monitoringConfiguration.monitorEnabled()) {
            for (String service : services) {
                componentContext.enableComponent(service);
            }
        } else {
            for (String service : services) {
                componentContext.disableComponent(service);
            }
        }
    }

    private List<String> _loadGateKeptServices(Bundle bundle) throws Exception {
        ArrayList<String> services = new ArrayList<String>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Enumeration enumeration = bundle.findEntries("/OSGI-INF", "*.xml", false);
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            InputStream is = url.openStream();
            Throwable throwable = null;
            try {
                Document document = documentBuilder.parse(is);
                Element element = document.getDocumentElement();
                String enabled = element.getAttribute("enabled");
                if (enabled.isEmpty() || Boolean.valueOf(enabled).booleanValue()) continue;
                services.add(element.getAttribute("name"));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return services;
    }
}

