/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.service;

import com.liferay.portal.kernel.monitoring.DataSampleProcessor;
import com.liferay.portal.kernel.monitoring.MethodSignature;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.monitoring.internal.statistics.RequestStatistics;
import com.liferay.portal.monitoring.internal.statistics.service.ServiceRequestDataSample;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceStatistics
implements DataSampleProcessor<ServiceRequestDataSample> {
    private final String _className;
    private final Map<MethodSignature, RequestStatistics> _methodRequestStatistics = new ConcurrentHashMap<MethodSignature, RequestStatistics>();

    public ServiceStatistics(String className) {
        this._className = className;
    }

    public long getAverageTime(String methodName, String[] parameterTypes) {
        MethodSignature methodSignature = new MethodSignature(this._className, methodName, parameterTypes);
        RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodSignature);
        if (requestStatistics != null) {
            return requestStatistics.getAverageTime();
        }
        return -1L;
    }

    public long getErrorCount(String methodName, String[] parameterTypes) {
        MethodSignature methodSignature = new MethodSignature(this._className, methodName, parameterTypes);
        RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodSignature);
        if (requestStatistics != null) {
            return requestStatistics.getErrorCount();
        }
        return -1L;
    }

    public long getMaxTime(String methodName, String[] parameterTypes) {
        MethodSignature methodSignature = new MethodSignature(this._className, methodName, parameterTypes);
        RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodSignature);
        if (requestStatistics != null) {
            return requestStatistics.getMaxTime();
        }
        return -1L;
    }

    public long getMinTime(String methodName, String[] parameterTypes) {
        MethodSignature methodSignature = new MethodSignature(this._className, methodName, parameterTypes);
        RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodSignature);
        if (requestStatistics != null) {
            return requestStatistics.getMinTime();
        }
        return -1L;
    }

    public long getRequestCount(String methodName, String[] parameterTypes) {
        MethodSignature methodSignature = new MethodSignature(this._className, methodName, parameterTypes);
        RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodSignature);
        if (requestStatistics != null) {
            return requestStatistics.getRequestCount();
        }
        return -1L;
    }

    public void processDataSample(ServiceRequestDataSample serviceRequestDataSample) {
        RequestStatus requestStatus;
        MethodSignature methodSignature = serviceRequestDataSample.getMethodSignature();
        RequestStatistics requestStatistics = this._methodRequestStatistics.get(methodSignature);
        if (requestStatistics == null) {
            requestStatistics = new RequestStatistics(methodSignature.toString());
            this._methodRequestStatistics.put(methodSignature, requestStatistics);
        }
        if ((requestStatus = serviceRequestDataSample.getRequestStatus()) == RequestStatus.ERROR) {
            requestStatistics.incrementError();
        } else if (requestStatus == RequestStatus.TIMEOUT) {
            requestStatistics.incrementTimeout();
        } else if (requestStatus == RequestStatus.SUCCESS) {
            requestStatistics.incrementSuccessDuration(serviceRequestDataSample.getDuration());
        }
    }
}

