/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.service;

import com.liferay.portal.kernel.monitoring.DataSampleProcessor;
import com.liferay.portal.kernel.monitoring.MethodSignature;
import com.liferay.portal.monitoring.internal.statistics.service.ServiceRequestDataSample;
import com.liferay.portal.monitoring.internal.statistics.service.ServiceStatistics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;

@Component(enabled=false, immediate=true, property={"namespace=com.liferay.monitoring.Service"}, service={DataSampleProcessor.class, ServerStatistics.class})
public class ServerStatistics
implements DataSampleProcessor<ServiceRequestDataSample> {
    private final Map<String, ServiceStatistics> _serviceStatistics = new ConcurrentHashMap<String, ServiceStatistics>();

    public long getAverageTime(String className, String methodName, String[] parameterTypes) {
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics != null) {
            return serviceStatistics.getAverageTime(methodName, parameterTypes);
        }
        return -1L;
    }

    public long getErrorCount(String className, String methodName, String[] parameterTypes) {
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics != null) {
            return serviceStatistics.getErrorCount(methodName, parameterTypes);
        }
        return -1L;
    }

    public long getMaxTime(String className, String methodName, String[] parameterTypes) {
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics != null) {
            return serviceStatistics.getMaxTime(methodName, parameterTypes);
        }
        return -1L;
    }

    public long getMinTime(String className, String methodName, String[] parameterTypes) {
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics != null) {
            return serviceStatistics.getMinTime(methodName, parameterTypes);
        }
        return -1L;
    }

    public long getRequestCount(String className, String methodName, String[] parameterTypes) {
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics != null) {
            return serviceStatistics.getRequestCount(methodName, parameterTypes);
        }
        return -1L;
    }

    public void processDataSample(ServiceRequestDataSample serviceRequestDataSample) {
        MethodSignature methodSignature = serviceRequestDataSample.getMethodSignature();
        String className = methodSignature.getClassName();
        ServiceStatistics serviceStatistics = this._serviceStatistics.get(className);
        if (serviceStatistics == null) {
            serviceStatistics = new ServiceStatistics(className);
            this._serviceStatistics.put(className, serviceStatistics);
        }
        serviceStatistics.processDataSample(serviceRequestDataSample);
    }
}

