/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.portal;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.CompanyConstants;
import com.liferay.portal.kernel.monitoring.DataSampleProcessor;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.monitoring.internal.statistics.RequestStatistics;
import com.liferay.portal.monitoring.internal.statistics.portal.PortalRequestDataSample;

public class CompanyStatistics
implements DataSampleProcessor<PortalRequestDataSample> {
    private static final long _START_TIME = System.currentTimeMillis();
    private final long _companyId;
    private long _maxTime;
    private long _minTime;
    private final RequestStatistics _requestStatistics;
    private final String _webId;

    public CompanyStatistics() {
        this._companyId = 0L;
        this._webId = CompanyConstants.SYSTEM_STRING;
        this._requestStatistics = new RequestStatistics(this._webId);
    }

    public CompanyStatistics(CompanyLocalService companyLocalService, String webId) {
        try {
            Company company = companyLocalService.getCompanyByWebId(webId);
            this._companyId = company.getCompanyId();
            this._webId = webId;
            this._requestStatistics = new RequestStatistics(this._webId);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get company with web id " + webId, e);
        }
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public long getMaxTime() {
        return this._maxTime;
    }

    public long getMinTime() {
        return this._minTime;
    }

    public RequestStatistics getRequestStatistics() {
        return this._requestStatistics;
    }

    public long getStartTime() {
        return _START_TIME;
    }

    public long getUptime() {
        return System.currentTimeMillis() - _START_TIME;
    }

    public String getWebId() {
        return this._webId;
    }

    public void processDataSample(PortalRequestDataSample portalRequestDataSample) {
        if (portalRequestDataSample.getCompanyId() != this._companyId) {
            return;
        }
        RequestStatus requestStatus = portalRequestDataSample.getRequestStatus();
        if (requestStatus.equals((Object)RequestStatus.ERROR)) {
            this._requestStatistics.incrementError();
        } else if (requestStatus.equals((Object)RequestStatus.SUCCESS)) {
            this._requestStatistics.incrementSuccessDuration(portalRequestDataSample.getDuration());
        } else if (requestStatus.equals((Object)RequestStatus.TIMEOUT)) {
            this._requestStatistics.incrementTimeout();
        }
        long duration = portalRequestDataSample.getDuration();
        if (this._maxTime < duration) {
            this._maxTime = duration;
        } else if (this._minTime > duration) {
            this._minTime = duration;
        }
    }

    public void reset() {
        this._maxTime = 0L;
        this._minTime = 0L;
        this._requestStatistics.reset();
    }
}

