/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.servlet.taglib;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.monitoring.DataSample;
import com.liferay.portal.kernel.monitoring.DataSampleThreadLocal;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.servlet.taglib.BaseDynamicInclude;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration;
import com.liferay.portal.monitoring.internal.statistics.portal.PortalRequestDataSample;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration"}, enabled=false, immediate=true, service={DynamicInclude.class})
public class MonitoringBottomDynamicInclude
extends BaseDynamicInclude {
    private volatile MonitoringConfiguration _monitoringConfiguration;

    public void include(HttpServletRequest request, HttpServletResponse response, String key) throws IOException {
        if (!this._monitoringConfiguration.monitorPortalRequest()) {
            return;
        }
        PortalRequestDataSample portalRequestDataSample = (PortalRequestDataSample)request.getAttribute("PORTAL_REQUEST_DATA_SAMPLE");
        if (portalRequestDataSample != null) {
            portalRequestDataSample.capture(RequestStatus.SUCCESS);
            portalRequestDataSample.setStatusCode(response.getStatus());
            DataSampleThreadLocal.addDataSample((DataSample)portalRequestDataSample);
        }
        List dataSamples = DataSampleThreadLocal.getDataSamples();
        if (!this._monitoringConfiguration.showPerRequestDataSample() || ListUtil.isEmpty((List)dataSamples)) {
            return;
        }
        StringBundler sb = new StringBundler(dataSamples.size() * 2 + 2);
        sb.append("<!--\n");
        for (DataSample curDataSample : dataSamples) {
            sb.append(HtmlUtil.escape((String)curDataSample.toString()));
            sb.append("\n");
        }
        sb.append("-->");
        PrintWriter printWriter = response.getWriter();
        printWriter.println(sb);
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/bottom.jsp#post");
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._monitoringConfiguration = (MonitoringConfiguration)ConfigurableUtil.createConfigurable(MonitoringConfiguration.class, properties);
    }
}

