/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.portlet;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.monitoring.DataSample;
import com.liferay.portal.kernel.monitoring.DataSampleFactory;
import com.liferay.portal.kernel.monitoring.DataSampleThreadLocal;
import com.liferay.portal.kernel.monitoring.PortletMonitoringControl;
import com.liferay.portal.kernel.monitoring.PortletRequestType;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.portlet.InvokerFilterContainer;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.HeaderFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;

public class MonitoringInvokerPortlet
implements InvokerFilterContainer,
InvokerPortlet {
    private long _actionTimeout;
    private final DataSampleFactory _dataSampleFactory;
    private long _headerTimeout;
    private InvokerPortlet _invokerPortlet;
    private final PortletMonitoringControl _portletMonitoringControl;
    private long _renderTimeout;

    public MonitoringInvokerPortlet(InvokerPortlet invokerPortlet, DataSampleFactory dataSampleFactory, PortletMonitoringControl portletMonitoringControl) {
        this._invokerPortlet = invokerPortlet;
        this._dataSampleFactory = dataSampleFactory;
        this._portletMonitoringControl = portletMonitoringControl;
    }

    public void destroy() {
        this._invokerPortlet.destroy();
    }

    public List<ActionFilter> getActionFilters() {
        InvokerFilterContainer invokerFilterContainer = (InvokerFilterContainer)this._invokerPortlet;
        return invokerFilterContainer.getActionFilters();
    }

    public List<EventFilter> getEventFilters() {
        InvokerFilterContainer invokerFilterContainer = (InvokerFilterContainer)this._invokerPortlet;
        return invokerFilterContainer.getEventFilters();
    }

    public Integer getExpCache() {
        return this._invokerPortlet.getExpCache();
    }

    public List<HeaderFilter> getHeaderFilters() {
        InvokerFilterContainer invokerFilterContainer = (InvokerFilterContainer)this._invokerPortlet;
        return invokerFilterContainer.getHeaderFilters();
    }

    public javax.portlet.Portlet getPortlet() {
        return this._invokerPortlet.getPortlet();
    }

    public ClassLoader getPortletClassLoader() {
        return this._invokerPortlet.getPortletClassLoader();
    }

    public PortletConfig getPortletConfig() {
        return this._invokerPortlet.getPortletConfig();
    }

    public PortletContext getPortletContext() {
        return this._invokerPortlet.getPortletContext();
    }

    public javax.portlet.Portlet getPortletInstance() {
        return this._invokerPortlet.getPortletInstance();
    }

    public List<RenderFilter> getRenderFilters() {
        InvokerFilterContainer invokerFilterContainer = (InvokerFilterContainer)this._invokerPortlet;
        return invokerFilterContainer.getRenderFilters();
    }

    public List<ResourceFilter> getResourceFilters() {
        InvokerFilterContainer invokerFilterContainer = (InvokerFilterContainer)this._invokerPortlet;
        return invokerFilterContainer.getResourceFilters();
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        this._invokerPortlet.init((PortletConfig)liferayPortletConfig);
        Portlet portletModel = liferayPortletConfig.getPortlet();
        this._actionTimeout = portletModel.getActionTimeout();
        this._headerTimeout = portletModel.getHeaderTimeout();
        this._renderTimeout = portletModel.getRenderTimeout();
    }

    public boolean isCheckAuthToken() {
        return this._invokerPortlet.isCheckAuthToken();
    }

    public boolean isFacesPortlet() {
        return this._invokerPortlet.isFacesPortlet();
    }

    public boolean isHeaderPortlet() {
        return this._invokerPortlet.isHeaderPortlet();
    }

    @Deprecated
    public boolean isStrutsBridgePortlet() {
        return false;
    }

    @Deprecated
    public boolean isStrutsPortlet() {
        return this._invokerPortlet.isStrutsPortlet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        DataSample dataSample = null;
        try {
            if (this._portletMonitoringControl.isMonitorPortletActionRequest()) {
                dataSample = this._dataSampleFactory.createPortletRequestDataSample(PortletRequestType.ACTION, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
                dataSample.setTimeout(this._actionTimeout);
                dataSample.prepare();
                DataSampleThreadLocal.initialize();
            }
            this._invokerPortlet.processAction(actionRequest, actionResponse);
            if (this._portletMonitoringControl.isMonitorPortletActionRequest() && dataSample != null) {
                dataSample.capture(RequestStatus.SUCCESS);
            }
            if (dataSample == null) return;
        }
        catch (Exception e) {
            try {
                this._processException(this._portletMonitoringControl.isMonitorPortletActionRequest(), dataSample, e);
                if (dataSample == null) return;
            }
            catch (Throwable throwable) {
                if (dataSample == null) throw throwable;
                DataSampleThreadLocal.addDataSample(dataSample);
                throw throwable;
            }
            DataSampleThreadLocal.addDataSample((DataSample)dataSample);
            return;
        }
        DataSampleThreadLocal.addDataSample((DataSample)dataSample);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        DataSample dataSample = null;
        try {
            if (this._portletMonitoringControl.isMonitorPortletEventRequest()) {
                dataSample = this._dataSampleFactory.createPortletRequestDataSample(PortletRequestType.EVENT, (PortletRequest)eventRequest, (PortletResponse)eventResponse);
                dataSample.prepare();
                DataSampleThreadLocal.initialize();
            }
            this._invokerPortlet.processEvent(eventRequest, eventResponse);
            if (this._portletMonitoringControl.isMonitorPortletEventRequest() && dataSample != null) {
                dataSample.capture(RequestStatus.SUCCESS);
            }
            if (dataSample == null) return;
        }
        catch (Exception e) {
            try {
                this._processException(this._portletMonitoringControl.isMonitorPortletEventRequest(), dataSample, e);
                if (dataSample == null) return;
            }
            catch (Throwable throwable) {
                if (dataSample == null) throw throwable;
                DataSampleThreadLocal.addDataSample(dataSample);
                throw throwable;
            }
            DataSampleThreadLocal.addDataSample((DataSample)dataSample);
            return;
        }
        DataSampleThreadLocal.addDataSample((DataSample)dataSample);
        return;
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this._render(renderRequest, (MimeResponse)renderResponse, () -> this._invokerPortlet.render(renderRequest, renderResponse), PortletRequestType.RENDER, this._renderTimeout);
    }

    public void renderHeaders(HeaderRequest headerRequest, HeaderResponse headerResponse) throws IOException, PortletException {
        this._render((RenderRequest)headerRequest, (MimeResponse)headerResponse, () -> this._invokerPortlet.renderHeaders(headerRequest, headerResponse), PortletRequestType.HEADER, this._headerTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        DataSample dataSample = null;
        try {
            if (this._portletMonitoringControl.isMonitorPortletResourceRequest()) {
                dataSample = this._dataSampleFactory.createPortletRequestDataSample(PortletRequestType.RESOURCE, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
                dataSample.prepare();
                DataSampleThreadLocal.initialize();
            }
            this._invokerPortlet.serveResource(resourceRequest, resourceResponse);
            if (this._portletMonitoringControl.isMonitorPortletResourceRequest() && dataSample != null) {
                dataSample.capture(RequestStatus.SUCCESS);
            }
            if (dataSample == null) return;
        }
        catch (Exception e) {
            try {
                this._processException(this._portletMonitoringControl.isMonitorPortletResourceRequest(), dataSample, e);
                if (dataSample == null) return;
            }
            catch (Throwable throwable) {
                if (dataSample == null) throw throwable;
                DataSampleThreadLocal.addDataSample(dataSample);
                throw throwable;
            }
            DataSampleThreadLocal.addDataSample((DataSample)dataSample);
            return;
        }
        DataSampleThreadLocal.addDataSample((DataSample)dataSample);
        return;
    }

    public void setInvokerPortlet(InvokerPortlet invokerPortlet) {
        this._invokerPortlet = invokerPortlet;
    }

    public void setPortletFilters() throws PortletException {
        this._invokerPortlet.setPortletFilters();
    }

    private void _processException(boolean monitorPortletRequest, DataSample dataSample, Exception e) throws IOException, PortletException {
        if (monitorPortletRequest && dataSample != null) {
            dataSample.capture(RequestStatus.ERROR);
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof PortletException) {
            throw (PortletException)e;
        }
        throw new PortletException("Unable to process portlet", (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _render(RenderRequest renderRequest, MimeResponse mimeResponse, Renderable renderable, PortletRequestType portletRequestType, long timeout) throws IOException, PortletException {
        DataSample dataSample = null;
        try {
            if (this._portletMonitoringControl.isMonitorPortletHeaderRequest() || this._portletMonitoringControl.isMonitorPortletRenderRequest()) {
                dataSample = this._dataSampleFactory.createPortletRequestDataSample(portletRequestType, (PortletRequest)renderRequest, (PortletResponse)mimeResponse);
                dataSample.setTimeout(timeout);
                dataSample.prepare();
                DataSampleThreadLocal.initialize();
            }
            renderable.render();
            if ((this._portletMonitoringControl.isMonitorPortletHeaderRequest() || this._portletMonitoringControl.isMonitorPortletRenderRequest()) && dataSample != null) {
                dataSample.capture(RequestStatus.SUCCESS);
            }
            if (dataSample == null) return;
        }
        catch (Exception e) {
            try {
                this._processException(this._portletMonitoringControl.isMonitorPortletHeaderRequest() || this._portletMonitoringControl.isMonitorPortletRenderRequest(), dataSample, e);
                if (dataSample == null) return;
            }
            catch (Throwable throwable) {
                if (dataSample == null) throw throwable;
                DataSampleThreadLocal.addDataSample(dataSample);
                throw throwable;
            }
            DataSampleThreadLocal.addDataSample((DataSample)dataSample);
            return;
        }
        DataSampleThreadLocal.addDataSample((DataSample)dataSample);
        return;
    }

    @FunctionalInterface
    private static interface Renderable {
        public void render() throws IOException, PortletException;
    }
}

