/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instances.internal.operation;

import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.Callable;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Reference;

public abstract class BasePortalInstanceOperation {
    @Reference
    protected ClusterMasterExecutor clusterMasterExecutor;
    @Reference
    protected ConfigurationAdmin configurationAdmin;
    private static final Log _log = LogFactoryUtil.getLog(BasePortalInstanceOperation.class);

    public abstract String getOperationCompletedMessage(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPortalInstance(Callable<Company> callable, Map<String, Object> properties) {
        try {
            if (!this.clusterMasterExecutor.isMaster()) {
                return;
            }
            Company company = callable.call();
            if (company != null) {
                this._deleteConfiguration((String)properties.get("service.pid"));
                if (_log.isInfoEnabled()) {
                    _log.info((Object)this.getOperationCompletedMessage(company.getCompanyId()));
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to perform operation on portal instance", (Throwable)exception);
        }
        finally {
            this._deleteConfiguration((String)properties.get("service.pid"));
        }
    }

    private void _deleteConfiguration(String pid) {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration(pid, "?");
            if (configuration == null) {
                return;
            }
            Dictionary properties = configuration.getProperties();
            if (properties != null && Validator.isNotNull(properties.get("felix.fileinstall.filename"))) {
                Files.deleteIfExists(Paths.get(PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR, pid.concat(".config")));
                return;
            }
            configuration.delete();
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
    }
}

