/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instances.internal.operation;

import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.instances.internal.configuration.ExtractPortalInstanceConfiguration;
import com.liferay.portal.instances.internal.operation.BasePortalInstanceOperation;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import java.util.Objects;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.instances.internal.configuration.ExtractPortalInstanceConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class ExtractPortalInstanceOperation
extends BasePortalInstanceOperation {
    private static final Log _log = LogFactoryUtil.getLog(ExtractPortalInstanceOperation.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    @Override
    public String getOperationCompletedMessage(long companyId) {
        return "Portal instance with company ID " + companyId + " extracted successfully";
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.onPortalInstance(() -> {
            FeatureFlagManagerUtil.checkEnabled((String)"LPD-11342");
            ExtractPortalInstanceConfiguration extractPortalInstanceConfiguration = (ExtractPortalInstanceConfiguration)ConfigurableUtil.createConfigurable(ExtractPortalInstanceConfiguration.class, (Map)properties);
            long companyId = extractPortalInstanceConfiguration.extractCompanyId();
            if (this._companyLocalService.fetchCompany(companyId) == null) {
                _log.error((Object)("Portal instance with company ID " + companyId + " does not exist"));
                return null;
            }
            Company company = this._companyLocalService.extractCompany(companyId);
            this._extractConfigurations(companyId);
            return company;
        }, properties);
    }

    private void _extractConfigurations(long companyId) throws Exception {
        if (DBPartition.isPartitionEnabled()) {
            return;
        }
        ArrayList<ScopedConfiguration> scopedConfigurations = new ArrayList<ScopedConfiguration>();
        Map configurations = DBPartitionUtil.getConfigurations((long)0L);
        for (Map.Entry entry : configurations.entrySet()) {
            String dictionaryString = (String)entry.getValue();
            ScopedConfiguration scopedConfiguration = this._getScopedConfiguration((String)entry.getKey(), dictionaryString);
            if (scopedConfiguration == null) continue;
            if (Objects.equals(scopedConfiguration.getScope(), ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE)) {
                scopedConfigurations.add(scopedConfiguration);
                continue;
            }
            if (!this._isApplicable(companyId, scopedConfiguration)) continue;
            scopedConfigurations.add(scopedConfiguration);
        }
        for (ScopedConfiguration scopedConfiguration : scopedConfigurations) {
            DBPartitionUtil.extractConfiguration((long)companyId, (String)scopedConfiguration.getConfigurationId(), (String)scopedConfiguration.getDictionaryString());
        }
    }

    private ScopedConfiguration _getScopedConfiguration(String configurationId, String dictionaryString) throws Exception {
        Dictionary dictionary = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionaryString.getBytes("UTF-8")));
        Object value = dictionary.get(ExtendedObjectClassDefinition.Scope.COMPANY.getPropertyKey());
        if (value != null) {
            return new ScopedConfiguration(configurationId, dictionaryString, Long.valueOf(GetterUtil.getLong(value)), ExtendedObjectClassDefinition.Scope.COMPANY);
        }
        value = dictionary.get(ExtendedObjectClassDefinition.Scope.GROUP.getPropertyKey());
        if (value != null) {
            return new ScopedConfiguration(configurationId, dictionaryString, Long.valueOf(GetterUtil.getLong(value)), ExtendedObjectClassDefinition.Scope.GROUP);
        }
        value = dictionary.get(ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE.getPropertyKey());
        if (value != null) {
            return new ScopedConfiguration(configurationId, dictionaryString, (Serializable)((Object)GetterUtil.getString(value)), ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE);
        }
        return null;
    }

    private boolean _isApplicable(long companyId, ScopedConfiguration scopedConfiguration) throws Exception {
        if (Objects.equals(scopedConfiguration.getScope(), ExtendedObjectClassDefinition.Scope.COMPANY)) {
            return companyId == (Long)scopedConfiguration.getScopePK();
        }
        if (Objects.equals(scopedConfiguration.getScope(), ExtendedObjectClassDefinition.Scope.GROUP)) {
            Group group = this._groupLocalService.getGroup(((Long)scopedConfiguration.getScopePK()).longValue());
            return group.getCompanyId() == companyId;
        }
        return true;
    }

    private class ScopedConfiguration {
        private final String _configurationId;
        private final String _dictionaryString;
        private final ExtendedObjectClassDefinition.Scope _scope;
        private final Object _scopePK;

        public ScopedConfiguration(String configurationId, String dictionaryString, Serializable scopePK, ExtendedObjectClassDefinition.Scope scope) {
            this._configurationId = configurationId;
            this._dictionaryString = dictionaryString;
            this._scopePK = scopePK;
            this._scope = scope;
        }

        public String getConfigurationId() {
            return this._configurationId;
        }

        public String getDictionaryString() {
            return this._dictionaryString;
        }

        public ExtendedObjectClassDefinition.Scope getScope() {
            return this._scope;
        }

        public Object getScopePK() {
            return this._scopePK;
        }
    }
}

