/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instances.service.impl;

import com.liferay.portal.instances.service.base.PortalInstancesLocalServiceBaseImpl;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.CompanyService;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.util.PortalInstances;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PortalInstancesLocalServiceImpl
extends PortalInstancesLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortalInstancesLocalServiceImpl.class);
    @ServiceReference(type=CompanyLocalService.class)
    private CompanyLocalService _companyLocalService;
    @ServiceReference(type=CompanyService.class)
    private CompanyService _companyService;
    @ServiceReference(type=Portal.class)
    private Portal _portal;

    public void addCompanyId(long companyId) {
        PortalInstances.addCompanyId((long)companyId);
    }

    public long getCompanyId(HttpServletRequest request) {
        return PortalInstances.getCompanyId((HttpServletRequest)request);
    }

    public long[] getCompanyIds() {
        return PortalInstances.getCompanyIds();
    }

    public long[] getCompanyIdsBySQL() throws SQLException {
        return PortalInstances.getCompanyIdsBySQL();
    }

    public long getDefaultCompanyId() {
        return PortalInstances.getDefaultCompanyId();
    }

    public String[] getWebIds() {
        return PortalInstances.getWebIds();
    }

    public void initializePortalInstance(ServletContext servletContext, String webId) {
        PortalInstances.initCompany((ServletContext)servletContext, (String)webId);
    }

    public boolean isAutoLoginIgnoreHost(String host) {
        return PortalInstances.isAutoLoginIgnoreHost((String)host);
    }

    public boolean isAutoLoginIgnorePath(String path) {
        return PortalInstances.isAutoLoginIgnorePath((String)path);
    }

    public boolean isCompanyActive(long companyId) {
        return PortalInstances.isCompanyActive((long)companyId);
    }

    public boolean isVirtualHostsIgnoreHost(String host) {
        return PortalInstances.isVirtualHostsIgnoreHost((String)host);
    }

    public boolean isVirtualHostsIgnorePath(String path) {
        return PortalInstances.isVirtualHostsIgnorePath((String)path);
    }

    public void reload(ServletContext servletContext) {
        PortalInstances.reload((ServletContext)servletContext);
    }

    public void removeCompany(long companyId) {
        PortalInstances.removeCompany((long)companyId);
    }

    @Clusterable
    public void synchronizePortalInstances() {
        try {
            long[] initializedCompanyIds = this._portal.getCompanyIds();
            List removeableCompanyIds = ListUtil.fromArray((long[])initializedCompanyIds);
            List companies = this._companyLocalService.getCompanies();
            for (Company company : companies) {
                long companyId = company.getCompanyId();
                removeableCompanyIds.remove(companyId);
                if (ArrayUtil.contains((long[])initializedCompanyIds, (long)companyId)) continue;
                ServletContext portalContext = ServletContextPool.get((String)this._portal.getPathContext());
                PortalInstances.initCompany((ServletContext)portalContext, (String)company.getWebId());
            }
            Iterator iterator = removeableCompanyIds.iterator();
            while (iterator.hasNext()) {
                long companyId = (Long)iterator.next();
                PortalInstances.removeCompany((long)companyId);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

