/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.extender.internal;

import com.liferay.osgi.felix.util.AbstractExtender;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.extender.internal.BundleStorage;
import com.liferay.portal.configuration.extender.internal.ConfigurationDescriptionFactory;
import com.liferay.portal.configuration.extender.internal.ConfiguratorExtension;
import com.liferay.portal.configuration.extender.internal.NamedConfigurationContent;
import com.liferay.portal.configuration.extender.internal.NamedConfigurationContentFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.utils.extender.Extension;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={})
public class ConfiguratorExtender
extends AbstractExtender {
    private ConfigurationAdmin _configurationAdmin;
    private final Collection<ConfigurationDescriptionFactory> _configurationDescriptionFactories = new CopyOnWriteArrayList<ConfigurationDescriptionFactory>();
    private Logger _logger;
    private final Collection<NamedConfigurationContentFactory> _namedConfigurationContentFactories = new CopyOnWriteArrayList<NamedConfigurationContentFactory>();

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        this._logger = new Logger(bundleContext);
        this.start(bundleContext);
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addConfigurationDescriptionFactory(ConfigurationDescriptionFactory configurationDescriptionFactory) {
        this._configurationDescriptionFactories.add(configurationDescriptionFactory);
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addNamedConfigurationContentFactory(NamedConfigurationContentFactory namedConfigurationContentFactory) {
        this._namedConfigurationContentFactories.add(namedConfigurationContentFactory);
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) throws Exception {
        this.stop(bundleContext);
    }

    protected void debug(Bundle bundle, String s) {
        this._logger.log(4, StringBundler.concat((Object[])new Object[]{"[", bundle, "] ", s}));
    }

    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        ArrayList<NamedConfigurationContent> namedConfigurationContents = new ArrayList<NamedConfigurationContent>();
        for (NamedConfigurationContentFactory namedConfigurationContentFactory : this._namedConfigurationContentFactories) {
            try {
                List<NamedConfigurationContent> contents = namedConfigurationContentFactory.create(new BundleStorageImpl(bundle));
                if (contents == null) continue;
                namedConfigurationContents.addAll(contents);
            }
            catch (Throwable t) {
                this._logger.log(3, t.getMessage(), t);
            }
        }
        if (namedConfigurationContents.isEmpty()) {
            return null;
        }
        return new ConfiguratorExtension(this._configurationAdmin, new Logger(bundle.getBundleContext()), bundle.getSymbolicName(), namedConfigurationContents, this._configurationDescriptionFactories);
    }

    protected void error(String s, Throwable throwable) {
        this._logger.log(1, s, throwable);
    }

    protected void removeConfigurationDescriptionFactory(ConfigurationDescriptionFactory configurationDescriptionFactory) {
        this._configurationDescriptionFactories.remove(configurationDescriptionFactory);
    }

    protected void removeNamedConfigurationContentFactory(NamedConfigurationContentFactory namedConfigurationContentFactory) {
        this._namedConfigurationContentFactories.remove(namedConfigurationContentFactory);
    }

    @Reference(unbind="-")
    protected void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this._configurationAdmin = configurationAdmin;
    }

    protected void warn(Bundle bundle, String s, Throwable throwable) {
        this._logger.log(2, StringBundler.concat((Object[])new Object[]{"[", bundle, "] ", s}));
    }

    private static class BundleStorageImpl
    implements BundleStorage {
        private final Bundle _bundle;

        public BundleStorageImpl(Bundle bundle) {
            this._bundle = bundle;
        }

        @Override
        public Enumeration<URL> findEntries(String root, String pattern, boolean recurse) {
            return this._bundle.findEntries(root, pattern, recurse);
        }

        @Override
        public long getBundleId() {
            return this._bundle.getBundleId();
        }

        @Override
        public URL getEntry(String name) {
            return this._bundle.getEntry(name);
        }

        @Override
        public Enumeration<String> getEntryPaths(String name) {
            return this._bundle.getEntryPaths(name);
        }

        @Override
        public Dictionary<String, String> getHeaders() {
            return this._bundle.getHeaders("");
        }

        @Override
        public String getLocation() {
            return this._bundle.getLocation();
        }

        @Override
        public URL getResource(String name) {
            return this._bundle.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this._bundle.getResources(name);
        }

        @Override
        public String getSymbolicName() {
            return this._bundle.getSymbolicName();
        }
    }
}

