/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cluster.multiple.configuration.ClusterExecutorConfiguration;
import com.liferay.portal.cluster.multiple.internal.ClusterChannel;
import com.liferay.portal.cluster.multiple.internal.ClusterChannelFactory;
import com.liferay.portal.cluster.multiple.internal.ClusterForwardReceiver;
import com.liferay.portal.cluster.multiple.internal.ClusterReceiver;
import com.liferay.portal.cluster.multiple.internal.jgroups.JGroupsClusterChannelFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.cluster.multiple.configuration.ClusterExecutorConfiguration"}, enabled=false, service={ClusterLink.class})
public class ClusterLinkImpl
implements ClusterLink {
    private static final Log _log = LogFactoryUtil.getLog(ClusterLinkImpl.class);
    private int _channelCount;
    private volatile ClusterChannelFactory _clusterChannelFactory;
    private List<ClusterChannel> _clusterChannels;
    private List<ClusterReceiver> _clusterReceivers;
    private boolean _enabled;
    private ExecutorService _executorService;
    private List<Address> _localAddresses;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    @Reference
    private Props _props;

    public boolean isEnabled() {
        return this._enabled;
    }

    public void sendMulticastMessage(Message message, Priority priority) {
        ClusterChannel clusterChannel = this.getChannel(priority);
        clusterChannel.sendMulticastMessage((Serializable)message);
    }

    public void sendUnicastMessage(Address address, Message message, Priority priority) {
        if (this._localAddresses.contains(address)) {
            this.sendLocalMessage(message);
            return;
        }
        ClusterChannel clusterChannel = this.getChannel(priority);
        clusterChannel.sendUnicastMessage((Serializable)message, address);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._enabled = true;
        this.modified(properties);
        this.initialize(this._getChannelSettings("cluster.link.channel.logic.name.transport"), this._getChannelSettings("cluster.link.channel.properties.transport"), this._getChannelSettings("cluster.link.channel.name.transport"));
    }

    @Deactivate
    protected void deactivate() {
        if (this._clusterChannels != null) {
            for (ClusterChannel clusterChannel : this._clusterChannels) {
                clusterChannel.close();
            }
        }
        this._localAddresses = null;
        this._clusterChannels = null;
        this._clusterReceivers = null;
        if (this._executorService != null) {
            this._executorService.shutdownNow();
        }
        this._executorService = null;
    }

    protected ClusterChannel getChannel(Priority priority) {
        int channelIndex = priority.ordinal() * this._channelCount / MAX_CHANNEL_COUNT;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Select channel number ", channelIndex, " for priority ", priority}));
        }
        return this._clusterChannels.get(channelIndex);
    }

    protected ExecutorService getExecutorService() {
        return this._executorService;
    }

    protected List<Address> getLocalAddresses() {
        return this._localAddresses;
    }

    protected void initialize(Map<String, String> channelLogicNames, Map<String, String> channelPropertiesLocations, Map<String, String> channelNames) {
        this._executorService = this._portalExecutorManager.getPortalExecutor(ClusterLinkImpl.class.getName());
        try {
            this._initChannels(channelLogicNames, channelPropertiesLocations, channelNames);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize channels", (Throwable)exception);
            throw new IllegalStateException(exception);
        }
        for (ClusterReceiver clusterReceiver : this._clusterReceivers) {
            clusterReceiver.openLatch();
        }
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this._clusterChannelFactory = new JGroupsClusterChannelFactory((ClusterExecutorConfiguration)ConfigurableUtil.createConfigurable(ClusterExecutorConfiguration.class, properties));
    }

    protected void sendLocalMessage(Message message) {
        String destinationName = message.getDestinationName();
        if (Validator.isNotNull((String)destinationName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Sending local cluster link message ", message, " to ", destinationName}));
            }
            ClusterInvokeThreadLocal.setEnabled((boolean)false);
            try {
                this._messageBus.sendMessage(destinationName, message);
            }
            finally {
                ClusterInvokeThreadLocal.setEnabled((boolean)true);
            }
        } else {
            _log.error((Object)("Local cluster link message has no destination " + String.valueOf(message)));
        }
    }

    private Map<String, String> _getChannelSettings(String propertyPrefix) {
        HashMap<String, String> channelSettings = new HashMap<String, String>();
        Properties channelProperties = this._props.getProperties(propertyPrefix, true);
        for (Map.Entry<Object, Object> entry : channelProperties.entrySet()) {
            channelSettings.put((String)entry.getKey(), (String)entry.getValue());
        }
        return channelSettings;
    }

    private void _initChannels(Map<String, String> channelLogicNames, Map<String, String> channelPropertiesLocations, Map<String, String> channelNames) throws Exception {
        this._channelCount = channelPropertiesLocations.size();
        if (this._channelCount <= 0 || this._channelCount > MAX_CHANNEL_COUNT) {
            throw new IllegalArgumentException("Channel count must be between 1 and " + MAX_CHANNEL_COUNT);
        }
        this._localAddresses = new ArrayList<Address>(this._channelCount);
        this._clusterChannels = new ArrayList<ClusterChannel>(this._channelCount);
        this._clusterReceivers = new ArrayList<ClusterReceiver>(this._channelCount);
        ArrayList<String> keys = new ArrayList<String>(channelPropertiesLocations.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String channelPropertiesLocation = channelPropertiesLocations.get(key);
            String channelName = channelNames.get(key);
            if (Validator.isNull((String)channelPropertiesLocation) || Validator.isNull((String)channelName)) continue;
            String channelLogicName = channelLogicNames.get(key);
            ClusterForwardReceiver clusterReceiver = new ClusterForwardReceiver(this);
            ClusterChannel clusterChannel = this._clusterChannelFactory.createClusterChannel(this._executorService, channelLogicName, channelPropertiesLocation, channelName, clusterReceiver);
            this._clusterChannels.add(clusterChannel);
            this._clusterReceivers.add(clusterReceiver);
            this._localAddresses.add(clusterChannel.getLocalAddress());
        }
    }
}

