/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cluster.multiple.configuration.ClusterExecutorConfiguration;
import com.liferay.portal.cluster.multiple.internal.ClusterChannel;
import com.liferay.portal.cluster.multiple.internal.ClusterChannelFactory;
import com.liferay.portal.cluster.multiple.internal.ClusterRequestReceiver;
import com.liferay.portal.cluster.multiple.internal.jgroups.JGroupsClusterChannelFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterException;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.PortalInetSocketAddressEventListener;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.cluster.multiple.configuration.ClusterExecutorConfiguration"}, enabled=false, service={ClusterExecutor.class})
public class ClusterExecutorImpl
implements ClusterExecutor {
    protected volatile ClusterExecutorConfiguration clusterExecutorConfiguration;
    private static final Log _log = LogFactoryUtil.getLog(ClusterExecutorImpl.class);
    private ClusterChannel _clusterChannel;
    private volatile ClusterChannelFactory _clusterChannelFactory;
    private final Map<Address, CompletableFuture<String>> _clusterNodeIdCompletableFutures = new ConcurrentHashMap<Address, CompletableFuture<String>>();
    private final Map<String, ClusterNodeStatus> _clusterNodeStatuses = new ConcurrentHashMap<String, ClusterNodeStatus>();
    private boolean _enabled;
    private ExecutorService _executorService;
    private final Map<String, FutureClusterResponses> _futureClusterResponses = new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private ClusterNodeStatus _localClusterNodeStatus;
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    @Reference
    private Props _props;
    private ServiceRegistration<PortalInetSocketAddressEventListener> _serviceRegistration;
    private ServiceTrackerList<ClusterEventListener> _serviceTrackerList;

    public FutureClusterResponses execute(ClusterRequest clusterRequest) {
        HashSet<Object> clusterNodeIds = new HashSet();
        if (clusterRequest.isMulticast()) {
            clusterNodeIds = new HashSet<String>(this._clusterNodeStatuses.keySet());
            if (clusterRequest.isSkipLocal()) {
                clusterNodeIds.remove(this._localClusterNodeStatus.getClusterNodeId());
            }
        } else {
            clusterNodeIds.addAll(clusterRequest.getTargetClusterNodeIds());
        }
        FutureClusterResponses futureClusterResponses = new FutureClusterResponses(clusterNodeIds);
        if (!clusterRequest.isFireAndForget()) {
            this._futureClusterResponses.put(clusterRequest.getUuid(), futureClusterResponses);
        }
        if (clusterNodeIds.remove(this._localClusterNodeStatus.getClusterNodeId())) {
            ClusterNodeResponse clusterNodeResponse = this.executeClusterRequest(clusterRequest);
            if (!clusterRequest.isFireAndForget()) {
                futureClusterResponses.addClusterNodeResponse(clusterNodeResponse);
            }
        }
        if (clusterRequest.isMulticast()) {
            this._clusterChannel.sendMulticastMessage((Serializable)clusterRequest);
        } else {
            for (String string : clusterNodeIds) {
                ClusterNodeStatus clusterNodeStatus = this._clusterNodeStatuses.get(string);
                if (clusterNodeStatus == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to get cluster node ", string, " while executing ", clusterRequest}));
                    continue;
                }
                this._clusterChannel.sendUnicastMessage((Serializable)clusterRequest, clusterNodeStatus.getAddress());
            }
        }
        return futureClusterResponses;
    }

    public InetAddress getBindInetAddress() {
        return this._clusterChannelFactory.getBindInetAddress();
    }

    public NetworkInterface getBindNetworkInterface() {
        return this._clusterChannelFactory.getBindNetworkInterface();
    }

    public List<ClusterEventListener> getClusterEventListeners() {
        return this._serviceTrackerList.toList();
    }

    public List<ClusterNode> getClusterNodes() {
        ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
        for (ClusterNodeStatus clusterNodeStatus : this._clusterNodeStatuses.values()) {
            clusterNodes.add(clusterNodeStatus.getClusterNode());
        }
        return clusterNodes;
    }

    public ClusterNode getLocalClusterNode() {
        return this._localClusterNodeStatus.getClusterNode();
    }

    public boolean isClusterNodeAlive(String clusterNodeId) {
        return this._clusterNodeStatuses.containsKey(clusterNodeId);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._enabled = true;
        this.modified(properties);
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, ClusterEventListener.class);
        this.initialize(this._props.get("cluster.link.channel.logic.name.control"), this._props.get("cluster.link.channel.properties.control"), this._props.get("cluster.link.channel.name.control"));
        this._serviceRegistration = bundleContext.registerService(PortalInetSocketAddressEventListener.class, (Object)new ClusterExecutorPortalInetSocketAddressEventListener(), (Dictionary)new HashMapDictionary());
    }

    @Deactivate
    protected void deactivate() {
        if (this._clusterChannel != null) {
            this._clusterChannel.close();
        }
        this._clusterChannel = null;
        if (this._executorService != null) {
            this._executorService.shutdownNow();
        }
        this._executorService = null;
        this._serviceTrackerList.close();
        this._clusterNodeStatuses.clear();
        this._futureClusterResponses.clear();
        this._localClusterNodeStatus = null;
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClusterNodeResponse executeClusterRequest(ClusterRequest clusterRequest) {
        Serializable payload = clusterRequest.getPayload();
        if (!(payload instanceof MethodHandler)) {
            return ClusterNodeResponse.createExceptionClusterNodeResponse((ClusterNode)this._localClusterNodeStatus.getClusterNode(), (String)clusterRequest.getUuid(), (Exception)new ClusterException("Payload is not of type " + MethodHandler.class.getName()));
        }
        MethodHandler methodHandler = (MethodHandler)payload;
        ClusterInvokeThreadLocal.setEnabled((boolean)false);
        try {
            Object result = methodHandler.invoke();
            if (result instanceof Serializable || result == null) {
                ClusterNodeResponse clusterNodeResponse = ClusterNodeResponse.createResultClusterNodeResponse((ClusterNode)this._localClusterNodeStatus.getClusterNode(), (String)clusterRequest.getUuid(), (Serializable)((Serializable)result));
                return clusterNodeResponse;
            }
            ClusterNodeResponse clusterNodeResponse = ClusterNodeResponse.createExceptionClusterNodeResponse((ClusterNode)this._localClusterNodeStatus.getClusterNode(), (String)clusterRequest.getUuid(), (Exception)new ClusterException(StringBundler.concat((Object[])new Object[]{methodHandler, " returned value ", result, " that is not serializable"})));
            return clusterNodeResponse;
        }
        catch (Exception exception) {
            ClusterNodeResponse clusterNodeResponse = ClusterNodeResponse.createExceptionClusterNodeResponse((ClusterNode)this._localClusterNodeStatus.getClusterNode(), (String)clusterRequest.getUuid(), (Exception)exception);
            return clusterNodeResponse;
        }
        finally {
            ClusterInvokeThreadLocal.setEnabled((boolean)true);
        }
    }

    protected void fireClusterEvent(ClusterEvent clusterEvent) {
        for (ClusterEventListener listener : this._serviceTrackerList) {
            listener.processClusterEvent(clusterEvent);
        }
    }

    protected ClusterChannel getClusterChannel() {
        return this._clusterChannel;
    }

    protected String getClusterNodeId(Address address) {
        CompletableFuture completableFuture = this._clusterNodeIdCompletableFutures.computeIfAbsent(address, key -> new CompletableFuture());
        try {
            return (String)completableFuture.get(this.clusterExecutorConfiguration.clusterNodeAddressTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to get cluster node with address " + String.valueOf(address)), (Throwable)exception);
            return null;
        }
    }

    protected ExecutorService getExecutorService() {
        return this._executorService;
    }

    protected void handleReceivedClusterNodeResponse(ClusterNodeResponse clusterNodeResponse) {
        Serializable result;
        Exception exception = clusterNodeResponse.getException();
        if (exception == null && (result = clusterNodeResponse.getResult()) instanceof ClusterNodeStatus) {
            this._memberJoined((ClusterNodeStatus)result);
            return;
        }
        String uuid = clusterNodeResponse.getUuid();
        FutureClusterResponses futureClusterResponses = this._futureClusterResponses.get(uuid);
        if (futureClusterResponses == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unable to get response container for " + uuid));
            }
            return;
        }
        if (!futureClusterResponses.addClusterNodeResponse(clusterNodeResponse) && _log.isWarnEnabled()) {
            ClusterNode clusterNode = clusterNodeResponse.getClusterNode();
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Unexpected cluster node ID ", clusterNode.getClusterNodeId(), " for response container with UUID ", uuid}));
        }
    }

    protected Serializable handleReceivedClusterRequest(ClusterRequest clusterRequest) {
        Serializable payload = clusterRequest.getPayload();
        if (payload instanceof ClusterNodeStatus) {
            this._memberJoined((ClusterNodeStatus)payload);
            return ClusterNodeResponse.createResultClusterNodeResponse((ClusterNode)this._localClusterNodeStatus.getClusterNode(), (String)clusterRequest.getUuid(), (Serializable)this._localClusterNodeStatus);
        }
        return this.executeClusterRequest(clusterRequest);
    }

    protected void initialize(String channelLogicName, String channelPropertiesLocation, String channelName) {
        if (Validator.isNull((String)channelPropertiesLocation)) {
            throw new IllegalStateException("Set \"cluster.link.channel.properties.control\"");
        }
        if (Validator.isNull((String)channelName)) {
            throw new IllegalStateException("Set \"cluster.link.channel.name.control\"");
        }
        this._executorService = this._portalExecutorManager.getPortalExecutor(ClusterExecutorImpl.class.getName());
        ClusterRequestReceiver clusterReceiver = new ClusterRequestReceiver(this);
        this._clusterChannel = this._clusterChannelFactory.createClusterChannel(this._executorService, channelLogicName, channelPropertiesLocation, channelName, clusterReceiver);
        ClusterNode localClusterNode = new ClusterNode(this._generateClusterNodeId(), this._clusterChannel.getBindInetAddress());
        this._localClusterNodeStatus = new ClusterNodeStatus(localClusterNode, this._clusterChannel.getLocalAddress());
        this._memberJoined(this._localClusterNodeStatus);
        this.sendNotifyRequest();
        clusterReceiver.openLatch();
        this._configurePortalInstanceCommunications();
    }

    protected void memberRemoved(List<Address> departAddresses) {
        for (Address address : departAddresses) {
            this._clusterNodeIdCompletableFutures.remove(address);
        }
        ArrayList<ClusterNode> departClusterNodes = new ArrayList<ClusterNode>();
        Collection<ClusterNodeStatus> clusterNodeStatuses = this._clusterNodeStatuses.values();
        Iterator<ClusterNodeStatus> iterator = clusterNodeStatuses.iterator();
        while (iterator.hasNext()) {
            ClusterNodeStatus clusterNodeStatus = iterator.next();
            if (!departAddresses.contains(clusterNodeStatus.getAddress())) continue;
            departClusterNodes.add(clusterNodeStatus.getClusterNode());
            iterator.remove();
        }
        if (departClusterNodes.isEmpty()) {
            return;
        }
        ClusterEvent clusterEvent = ClusterEvent.depart(departClusterNodes);
        this.fireClusterEvent(clusterEvent);
    }

    @Modified
    protected void modified(Map<String, Object> properies) {
        this.clusterExecutorConfiguration = (ClusterExecutorConfiguration)ConfigurableUtil.createConfigurable(ClusterExecutorConfiguration.class, properies);
        this._clusterChannelFactory = new JGroupsClusterChannelFactory(this.clusterExecutorConfiguration);
    }

    protected void sendNotifyRequest() {
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)this._localClusterNodeStatus, (boolean)true);
        this._clusterChannel.sendMulticastMessage((Serializable)clusterRequest);
    }

    private void _configurePortalInstanceCommunications() {
        if (this._localClusterNodeStatus == null || Validator.isNull((String)this._props.get("portal.instance.protocol"))) {
            return;
        }
        ClusterNode localClusterNode = this._localClusterNodeStatus.getClusterNode();
        localClusterNode.setPortalProtocol(this._props.get("portal.instance.protocol"));
        localClusterNode.setPortalInetSocketAddress(this._getConfiguredPortalInetSocketAddress(this._props));
    }

    private String _generateClusterNodeId() {
        UUID uuid = new UUID(SecureRandomUtil.nextLong(), SecureRandomUtil.nextLong());
        return uuid.toString();
    }

    private InetSocketAddress _getConfiguredPortalInetSocketAddress(Props props) {
        String portalInstanceInetSocketAddress = props.get("portal.instance.inet.socket.address");
        if (Validator.isNull((String)portalInstanceInetSocketAddress)) {
            throw new IllegalArgumentException("Portal instance host name and port needs to be set in the property \"portal.instance.inet.socket.address\"");
        }
        String[] parts = StringUtil.split((String)portalInstanceInetSocketAddress, (char)':');
        if (parts.length != 2) {
            throw new IllegalArgumentException("Unable to parse the portal instance host name and port from " + portalInstanceInetSocketAddress);
        }
        InetAddress hostInetAddress = null;
        try {
            hostInetAddress = InetAddress.getByName(parts[0]);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("Unable to parse the portal instance host name and port from " + portalInstanceInetSocketAddress, unknownHostException);
        }
        int port = -1;
        try {
            port = GetterUtil.getIntegerStrict((String)parts[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Unable to parse portal InetSocketAddress port from " + portalInstanceInetSocketAddress, numberFormatException);
        }
        return new InetSocketAddress(hostInetAddress, port);
    }

    private boolean _memberJoined(ClusterNodeStatus clusterNodeStatus) {
        CompletableFuture completableFuture = this._clusterNodeIdCompletableFutures.computeIfAbsent(clusterNodeStatus.getAddress(), key -> new CompletableFuture());
        completableFuture.complete(clusterNodeStatus.getClusterNodeId());
        ClusterNodeStatus oldClusterNodeStatus = this._clusterNodeStatuses.put(clusterNodeStatus.getClusterNodeId(), clusterNodeStatus);
        if (oldClusterNodeStatus != null) {
            if (!oldClusterNodeStatus.equals(clusterNodeStatus) && _log.isInfoEnabled()) {
                _log.info((Object)("Updated cluster node " + String.valueOf(clusterNodeStatus.getClusterNode())));
            }
            return false;
        }
        ClusterEvent clusterEvent = ClusterEvent.join((ClusterNode[])new ClusterNode[]{clusterNodeStatus.getClusterNode()});
        this.fireClusterEvent(clusterEvent);
        return true;
    }

    private static class ClusterNodeStatus
    implements Serializable {
        private final Address _address;
        private final ClusterNode _clusterNode;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ClusterNodeStatus)) {
                return false;
            }
            ClusterNodeStatus clusterNodeStatus = (ClusterNodeStatus)object;
            return Objects.equals(this._address, clusterNodeStatus._address) && Objects.equals(this._clusterNode, clusterNodeStatus._clusterNode);
        }

        public Address getAddress() {
            return this._address;
        }

        public ClusterNode getClusterNode() {
            return this._clusterNode;
        }

        public String getClusterNodeId() {
            return this._clusterNode.getClusterNodeId();
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (Object)this._clusterNode);
            return HashUtil.hash((int)hash, (Object)this._address);
        }

        private ClusterNodeStatus(ClusterNode clusterNode, Address address) {
            this._clusterNode = clusterNode;
            this._address = address;
        }
    }

    private class ClusterExecutorPortalInetSocketAddressEventListener
    implements PortalInetSocketAddressEventListener {
        private ClusterExecutorPortalInetSocketAddressEventListener() {
        }

        public void portalLocalInetSocketAddressConfigured(InetSocketAddress inetSocketAddress, boolean secure) {
            ClusterNode localClusterNode = ClusterExecutorImpl.this.getLocalClusterNode();
            if (localClusterNode == null || localClusterNode.getPortalProtocol() != null) {
                return;
            }
            localClusterNode.setPortalInetSocketAddress(inetSocketAddress);
            if (secure) {
                localClusterNode.setPortalProtocol("https");
            } else {
                localClusterNode.setPortalProtocol("http");
            }
            ClusterExecutorImpl.this.sendNotifyRequest();
        }

        public void portalServerInetSocketAddressConfigured(InetSocketAddress inetSocketAddress, boolean secure) {
        }
    }
}

