/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.cluster.multiple.internal.BaseClusterReceiver;
import com.liferay.portal.cluster.multiple.internal.ClusterChannel;
import com.liferay.portal.cluster.multiple.internal.ClusterExecutorImpl;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventType;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ClusterRequestReceiver
extends BaseClusterReceiver {
    private static final Log _log = LogFactoryUtil.getLog(ClusterRequestReceiver.class);
    private final ClusterExecutorImpl _clusterExecutorImpl;

    public ClusterRequestReceiver(ClusterExecutorImpl clusterExecutorImpl) {
        super(clusterExecutorImpl.getExecutorService());
        this._clusterExecutorImpl = clusterExecutorImpl;
    }

    @Override
    protected void doAddressesUpdated(List<Address> oldAddresses, List<Address> newAddresses) {
        ArrayList<Address> addedAddresses = new ArrayList<Address>(newAddresses);
        addedAddresses.removeAll(oldAddresses);
        if (!addedAddresses.isEmpty()) {
            this._clusterExecutorImpl.sendNotifyRequest();
        }
        ArrayList<Address> removedAddresses = new ArrayList<Address>(oldAddresses);
        removedAddresses.removeAll(newAddresses);
        if (!removedAddresses.isEmpty()) {
            this._clusterExecutorImpl.memberRemoved(removedAddresses);
        }
    }

    @Override
    protected void doCoordinatorAddressUpdated(Address oldCoordinatorAddress, Address newCoordinatorAddress) {
        if (oldCoordinatorAddress.equals(newCoordinatorAddress)) {
            return;
        }
        this._clusterExecutorImpl.fireClusterEvent(new ClusterEvent(ClusterEventType.COORDINATOR_ADDRESS_UPDATE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReceive(Object messagePayload, Address srcAddress) {
        ClusterChannel clusterChannel = this._clusterExecutorImpl.getClusterChannel();
        if (srcAddress.equals(clusterChannel.getLocalAddress())) {
            return;
        }
        try {
            if (messagePayload instanceof ClusterRequest) {
                ClusterRequest clusterRequest = (ClusterRequest)messagePayload;
                Serializable responsePayload = this._clusterExecutorImpl.handleReceivedClusterRequest(clusterRequest);
                if (clusterRequest.isFireAndForget()) {
                    return;
                }
                try {
                    clusterChannel.sendUnicastMessage(responsePayload, srcAddress);
                }
                catch (Throwable throwable) {
                    _log.error((Object)("Unable to send message " + responsePayload), throwable);
                }
            } else if (messagePayload instanceof ClusterNodeResponse) {
                this._clusterExecutorImpl.handleReceivedClusterNodeResponse((ClusterNodeResponse)messagePayload);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to process message content of type " + messagePayload.getClass()));
            }
        }
        finally {
            ThreadLocalCacheManager.clearAll((Lifecycle)Lifecycle.REQUEST);
            CentralizedThreadLocal.clearShortLivedThreadLocals();
        }
    }
}

