/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal.cluster.link.messaging;

import com.liferay.portal.cache.multiple.internal.PortalCacheClusterEvent;
import com.liferay.portal.cache.multiple.internal.PortalCacheClusterEventType;
import com.liferay.portal.cache.multiple.internal.PortalCacheManagerUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.util.SerializableUtil;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"destination.name=liferay/cache_replication"}, service={MessageListener.class})
public class ClusterLinkPortalCacheClusterListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ClusterLinkPortalCacheClusterListener.class);

    protected void doReceive(Message message) throws Exception {
        PortalCacheClusterEvent portalCacheClusterEvent = (PortalCacheClusterEvent)SerializableUtil.deserialize((byte[])message.getPayload(), ClusterLinkPortalCacheClusterListener.class.getClassLoader());
        if (portalCacheClusterEvent == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Payload is null");
            }
            return;
        }
        this.handlePortalCacheClusterEvent(portalCacheClusterEvent);
    }

    protected void handlePortalCacheClusterEvent(PortalCacheClusterEvent portalCacheClusterEvent) {
        PortalCacheManager<? extends Serializable, ?> portalCacheManager = PortalCacheManagerUtil.getPortalCacheManager(portalCacheClusterEvent.getPortalCacheManagerName());
        if (portalCacheManager == null) {
            return;
        }
        PortalCache portalCache = portalCacheManager.fetchPortalCache(portalCacheClusterEvent.getPortalCacheName());
        if (portalCache == null) {
            return;
        }
        PortalCacheClusterEventType portalCacheClusterEventType = portalCacheClusterEvent.getEventType();
        if (portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.REMOVE_ALL)) {
            PortalCacheHelperUtil.removeAllWithoutReplicator((PortalCache)portalCache);
        } else if (portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.PUT) || portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.UPDATE)) {
            Serializable key = portalCacheClusterEvent.getElementKey();
            Serializable value = portalCacheClusterEvent.getElementValue();
            if (value == null) {
                PortalCacheHelperUtil.removeWithoutReplicator((PortalCache)portalCache, (Serializable)key);
            } else {
                PortalCacheHelperUtil.putWithoutReplicator((PortalCache)portalCache, (Serializable)key, (Object)value, (int)portalCacheClusterEvent.getTimeToLive());
            }
        } else {
            PortalCacheHelperUtil.removeWithoutReplicator((PortalCache)portalCache, (Serializable)portalCacheClusterEvent.getElementKey());
        }
    }

    @Reference(target="(destination.name=liferay/cache_replication)", unbind="-")
    protected void setDestination(Destination destination) {
    }
}

