/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.service.impl;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.polls.exception.QuestionChoiceException;
import com.liferay.polls.exception.QuestionDescriptionException;
import com.liferay.polls.exception.QuestionExpirationDateException;
import com.liferay.polls.exception.QuestionTitleException;
import com.liferay.polls.model.PollsChoice;
import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.service.PollsChoiceLocalService;
import com.liferay.polls.service.base.PollsQuestionLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.polls.model.PollsQuestion"}, service={AopService.class})
public class PollsQuestionLocalServiceImpl
extends PollsQuestionLocalServiceBaseImpl {
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private PollsChoiceLocalService _pollsChoiceLocalService;
    @Reference
    private Portal _portal;

    @Indexable(type=IndexableType.REINDEX)
    public PollsQuestion addQuestion(long userId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, List<PollsChoice> choices, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), QuestionExpirationDateException.class);
        }
        this.validate(titleMap, descriptionMap, choices, expirationDate);
        long questionId = this.counterLocalService.increment();
        PollsQuestion question = this.pollsQuestionPersistence.create(questionId);
        question.setUuid(serviceContext.getUuid());
        question.setGroupId(groupId);
        question.setCompanyId(user.getCompanyId());
        question.setUserId(user.getUserId());
        question.setUserName(user.getFullName());
        question.setTitleMap(titleMap);
        question.setDescriptionMap(descriptionMap);
        question.setExpirationDate(expirationDate);
        question = (PollsQuestion)this.pollsQuestionPersistence.update((BaseModel)question);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addQuestionResources(question, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addQuestionResources(question, serviceContext.getModelPermissions());
        }
        if (choices != null) {
            for (PollsChoice choice : choices) {
                this._pollsChoiceLocalService.addChoice(userId, questionId, choice.getName(), choice.getDescription(), serviceContext);
            }
        }
        return question;
    }

    public void addQuestionResources(long questionId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        PollsQuestion question = this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        this.addQuestionResources(question, addGroupPermissions, addGuestPermissions);
    }

    public void addQuestionResources(long questionId, ModelPermissions modelPermissions) throws PortalException {
        PollsQuestion question = this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        this.addQuestionResources(question, modelPermissions);
    }

    public void addQuestionResources(PollsQuestion question, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(question.getCompanyId(), question.getGroupId(), question.getUserId(), PollsQuestion.class.getName(), question.getQuestionId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addQuestionResources(PollsQuestion question, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(question.getCompanyId(), question.getGroupId(), question.getUserId(), PollsQuestion.class.getName(), question.getQuestionId(), modelPermissions);
    }

    public void deleteQuestion(long questionId) throws PortalException {
        PollsQuestion question = this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        this.pollsQuestionLocalService.deleteQuestion(question);
    }

    @SystemEvent(action=1, type=1)
    public void deleteQuestion(PollsQuestion question) throws PortalException {
        this.pollsQuestionPersistence.remove((BaseModel)question);
        this.resourceLocalService.deleteResource(question.getCompanyId(), PollsQuestion.class.getName(), 4, question.getQuestionId());
        this.pollsChoicePersistence.removeByQuestionId(question.getQuestionId());
        this.pollsVotePersistence.removeByQuestionId(question.getQuestionId());
        Indexer indexer = this._indexerRegistry.getIndexer(PollsQuestion.class.getName());
        indexer.delete((Object)question);
    }

    public void deleteQuestions(long groupId) throws PortalException {
        for (PollsQuestion question : this.pollsQuestionPersistence.findByGroupId(groupId)) {
            this.pollsQuestionLocalService.deleteQuestion(question);
        }
    }

    public PollsQuestion getQuestion(long questionId) throws PortalException {
        return this.pollsQuestionPersistence.findByPrimaryKey(questionId);
    }

    public List<PollsQuestion> getQuestions(long groupId) {
        return this.pollsQuestionPersistence.findByGroupId(groupId);
    }

    public List<PollsQuestion> getQuestions(long groupId, int start, int end) {
        return this.pollsQuestionPersistence.findByGroupId(groupId, start, end);
    }

    public int getQuestionsCount(long groupId) {
        return this.pollsQuestionPersistence.countByGroupId(groupId);
    }

    public List<PollsQuestion> search(long groupId, int start, int end, OrderByComparator<PollsQuestion> orderByComparator) {
        return this.pollsQuestionPersistence.filterFindByGroupId(groupId, start, end, orderByComparator);
    }

    public List<PollsQuestion> search(long companyId, long[] groupIds, String keywords, int start, int end, OrderByComparator<PollsQuestion> orderByComparator) {
        return this.pollsQuestionFinder.findByKeywords(companyId, groupIds, keywords, start, end, orderByComparator);
    }

    public List<PollsQuestion> search(long companyId, long[] groupIds, String name, String description, boolean andOperator, int start, int end, OrderByComparator<PollsQuestion> orderByComparator) {
        return this.pollsQuestionFinder.findByC_G_T_D(companyId, groupIds, name, description, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long groupId) {
        return this.pollsQuestionPersistence.filterCountByGroupId(groupId);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords) {
        return this.pollsQuestionFinder.countByKeywords(companyId, groupIds, keywords);
    }

    public int searchCount(long companyId, long[] groupIds, String title, String description, boolean andOperator) {
        return this.pollsQuestionFinder.countByC_G_T_D(companyId, groupIds, title, description, andOperator);
    }

    @Indexable(type=IndexableType.REINDEX)
    public PollsQuestion updateQuestion(long userId, long questionId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, List<PollsChoice> choices, ServiceContext serviceContext) throws PortalException {
        Date expirationDate = null;
        if (!neverExpire) {
            User user = this.userLocalService.getUser(userId);
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), QuestionExpirationDateException.class);
        }
        this.validate(titleMap, descriptionMap, choices, expirationDate);
        PollsQuestion question = this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        question.setTitleMap(titleMap);
        question.setDescriptionMap(descriptionMap);
        question.setExpirationDate(expirationDate);
        question = (PollsQuestion)this.pollsQuestionPersistence.update((BaseModel)question);
        if (choices == null) {
            return question;
        }
        this.deleteRemovedPollsChoices(questionId, choices);
        for (PollsChoice choice : choices) {
            String choiceName = choice.getName();
            String choiceDescription = choice.getDescription();
            choice = this.pollsChoicePersistence.fetchByQ_N(questionId, choiceName);
            if (choice == null) {
                this._pollsChoiceLocalService.addChoice(userId, questionId, choiceName, choiceDescription, serviceContext);
                continue;
            }
            this._pollsChoiceLocalService.updateChoice(choice.getChoiceId(), questionId, choiceName, choiceDescription, serviceContext);
        }
        return question;
    }

    protected void deletePollsChoice(PollsChoice pollsChoice) {
        this.pollsVotePersistence.removeByChoiceId(pollsChoice.getChoiceId());
        this.pollsChoicePersistence.remove((BaseModel)pollsChoice);
    }

    protected void deleteRemovedPollsChoices(long questionId, List<PollsChoice> choices) {
        Stream stream = choices.stream();
        Stream<String> choiceNamesStream = stream.map(choice -> choice.getName());
        List choiceNames = choiceNamesStream.collect(Collectors.toList());
        List oldChoices = this.pollsChoicePersistence.findByQuestionId(questionId);
        Stream<Object> oldStream = oldChoices.stream();
        oldStream = oldStream.filter(oldChoice -> !choiceNames.contains(oldChoice.getName()));
        oldStream.forEach(this::deletePollsChoice);
    }

    protected void validate(Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, List<PollsChoice> choices, Date expirationDate) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String title = titleMap.get(locale);
        if (Validator.isNull((String)title)) {
            throw new QuestionTitleException();
        }
        String description = descriptionMap.get(locale);
        if (Validator.isNull((String)description)) {
            throw new QuestionDescriptionException();
        }
        if (choices != null && choices.size() < 2) {
            throw new QuestionChoiceException();
        }
        if (choices != null) {
            HashSet<String> choiceDescriptions = new HashSet<String>();
            for (PollsChoice choice : choices) {
                String choiceDescription = choice.getDescription(locale);
                if (Validator.isNull((String)choiceDescription) || choiceDescriptions.contains(choiceDescription)) {
                    throw new QuestionChoiceException();
                }
                choiceDescriptions.add(choiceDescription);
            }
        }
        if (!ExportImportThreadLocal.isImportInProcess() && expirationDate != null && expirationDate.before(new Date())) {
            throw new QuestionExpirationDateException("Expiration date " + expirationDate + " is in the past");
        }
    }
}

