/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.polls.model.PollsChoice;
import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.model.PollsVote;
import com.liferay.polls.service.PollsChoiceLocalService;
import com.liferay.polls.service.PollsQuestionLocalService;
import com.liferay.polls.service.PollsVoteLocalService;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_polls_web_portlet_PollsPortlet"}, service={PortletDataHandler.class})
public class PollsPortletDataHandler
extends BasePortletDataHandler {
    public static final String[] CLASS_NAMES = new String[]{PollsChoice.class.getName(), PollsQuestion.class.getName(), PollsVote.class.getName()};
    public static final String NAMESPACE = "polls";
    public static final String SCHEMA_VERSION = "1.0.0";
    private PollsChoiceLocalService _pollsChoiceLocalService;
    private PollsQuestionLocalService _pollsQuestionLocalService;
    private PollsVoteLocalService _pollsVoteLocalService;
    @Reference
    private Staging _staging;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    @Activate
    protected void activate() {
        this.setDataLocalized(true);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(PollsQuestion.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "questions", true, false, new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "votes", true, false, null, PollsVote.class.getName())}, PollsQuestion.class.getName())});
        this.setStagingControls(this.getExportControls());
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(PollsPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        this._pollsQuestionLocalService.deleteQuestions(portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortletPermissions("com.liferay.polls");
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (portletDataContext.getBooleanParameter(NAMESPACE, "questions")) {
            ExportActionableDynamicQuery questionActionableDynamicQuery = this._pollsQuestionLocalService.getExportActionableDynamicQuery(portletDataContext);
            questionActionableDynamicQuery.performActions();
            ExportActionableDynamicQuery choiceActionableDynamicQuery = this._pollsChoiceLocalService.getExportActionableDynamicQuery(portletDataContext);
            choiceActionableDynamicQuery.performActions();
            if (portletDataContext.getBooleanParameter(NAMESPACE, "votes")) {
                ExportActionableDynamicQuery voteActionableDynamicQuery = this._pollsVoteLocalService.getExportActionableDynamicQuery(portletDataContext);
                voteActionableDynamicQuery.performActions();
            }
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortletPermissions("com.liferay.polls");
        if (portletDataContext.getBooleanParameter(NAMESPACE, "questions")) {
            Element questionsElement = portletDataContext.getImportDataGroupElement(PollsQuestion.class);
            List questionElements = questionsElement.elements();
            for (Element questionElement : questionElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)questionElement);
            }
            Element choicesElement = portletDataContext.getImportDataGroupElement(PollsChoice.class);
            List choiceElements = choicesElement.elements();
            for (Element choiceElement : choiceElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)choiceElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "votes")) {
            Element votesElement = portletDataContext.getImportDataGroupElement(PollsVote.class);
            List voteElements = votesElement.elements();
            for (Element voteElement : voteElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)voteElement);
            }
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            this._staging.populateLastPublishDateCounts(portletDataContext, new StagedModelType[]{new StagedModelType(PollsChoice.class.getName()), new StagedModelType(PollsQuestion.class.getName()), new StagedModelType(PollsVote.class.getName())});
            return;
        }
        ExportActionableDynamicQuery choiceActionableDynamicQuery = this._pollsChoiceLocalService.getExportActionableDynamicQuery(portletDataContext);
        choiceActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery questionActionableDynamicQuery = this._pollsQuestionLocalService.getExportActionableDynamicQuery(portletDataContext);
        questionActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery voteActionableDynamicQuery = this._pollsVoteLocalService.getExportActionableDynamicQuery(portletDataContext);
        voteActionableDynamicQuery.performCount();
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setPollsChoiceLocalService(PollsChoiceLocalService pollsChoiceLocalService) {
        this._pollsChoiceLocalService = pollsChoiceLocalService;
    }

    @Reference(unbind="-")
    protected void setPollsQuestionLocalService(PollsQuestionLocalService pollsQuestionLocalService) {
        this._pollsQuestionLocalService = pollsQuestionLocalService;
    }

    @Reference(unbind="-")
    protected void setPollsVoteLocalService(PollsVoteLocalService pollsVoteLocalService) {
        this._pollsVoteLocalService = pollsVoteLocalService;
    }
}

