/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.service.impl;

import com.liferay.polls.model.PollsChoice;
import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.service.base.PollsQuestionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=polls", "json.web.service.context.path=PollsQuestion"}, service={AopService.class})
public class PollsQuestionServiceImpl
extends PollsQuestionServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.polls.model.PollsQuestion)")
    private ModelResourcePermission<PollsQuestion> _pollsQuestionModelResourcePermission;

    public PollsQuestion addQuestion(Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, List<PollsChoice> choices, ServiceContext serviceContext) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._pollsQuestionModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_QUESTION");
        return this.pollsQuestionLocalService.addQuestion(this.getUserId(), titleMap, descriptionMap, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, choices, serviceContext);
    }

    public void deleteQuestion(long questionId) throws PortalException {
        this._pollsQuestionModelResourcePermission.check(this.getPermissionChecker(), questionId, "DELETE");
        this.pollsQuestionLocalService.deleteQuestion(questionId);
    }

    public PollsQuestion getQuestion(long questionId) throws PortalException {
        this._pollsQuestionModelResourcePermission.check(this.getPermissionChecker(), questionId, "VIEW");
        return this.pollsQuestionLocalService.getQuestion(questionId);
    }

    public PollsQuestion updateQuestion(long questionId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, List<PollsChoice> choices, ServiceContext serviceContext) throws PortalException {
        this._pollsQuestionModelResourcePermission.check(this.getPermissionChecker(), questionId, "UPDATE");
        return this.pollsQuestionLocalService.updateQuestion(this.getUserId(), questionId, titleMap, descriptionMap, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, choices, serviceContext);
    }
}

