/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.service.http;

import com.liferay.polls.model.PollsChoiceSoap;
import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.model.PollsQuestionSoap;
import com.liferay.polls.model.impl.PollsChoiceModelImpl;
import com.liferay.polls.service.PollsQuestionServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.rmi.RemoteException;
import java.util.Map;

public class PollsQuestionServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(PollsQuestionServiceSoap.class);

    public static PollsQuestionSoap addQuestion(String[] titleMapLanguageIds, String[] titleMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, PollsChoiceSoap[] choices, ServiceContext serviceContext) throws RemoteException {
        try {
            Map titleMap = LocalizationUtil.getLocalizationMap((String[])titleMapLanguageIds, (String[])titleMapValues);
            Map descriptionMap = LocalizationUtil.getLocalizationMap((String[])descriptionMapLanguageIds, (String[])descriptionMapValues);
            PollsQuestion returnValue = PollsQuestionServiceUtil.addQuestion((Map)titleMap, (Map)descriptionMap, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, PollsChoiceModelImpl.toModels(choices), (ServiceContext)serviceContext);
            return PollsQuestionSoap.toSoapModel((PollsQuestion)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static void deleteQuestion(long questionId) throws RemoteException {
        try {
            PollsQuestionServiceUtil.deleteQuestion((long)questionId);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static PollsQuestionSoap getQuestion(long questionId) throws RemoteException {
        try {
            PollsQuestion returnValue = PollsQuestionServiceUtil.getQuestion((long)questionId);
            return PollsQuestionSoap.toSoapModel((PollsQuestion)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }

    public static PollsQuestionSoap updateQuestion(long questionId, String[] titleMapLanguageIds, String[] titleMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, PollsChoiceSoap[] choices, ServiceContext serviceContext) throws RemoteException {
        try {
            Map titleMap = LocalizationUtil.getLocalizationMap((String[])titleMapLanguageIds, (String[])titleMapValues);
            Map descriptionMap = LocalizationUtil.getLocalizationMap((String[])descriptionMapLanguageIds, (String[])descriptionMapValues);
            PollsQuestion returnValue = PollsQuestionServiceUtil.updateQuestion((long)questionId, (Map)titleMap, (Map)descriptionMap, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, PollsChoiceModelImpl.toModels(choices), (ServiceContext)serviceContext);
            return PollsQuestionSoap.toSoapModel((PollsQuestion)returnValue);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new RemoteException(exception.getMessage());
        }
    }
}

