/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.polls.model.PollsChoice;
import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.model.PollsVote;
import com.liferay.polls.service.PollsQuestionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class PollsQuestionStagedModelDataHandler
extends BaseStagedModelDataHandler<PollsQuestion> {
    public static final String[] CLASS_NAMES = new String[]{PollsQuestion.class.getName()};
    private PollsQuestionLocalService _pollsQuestionLocalService;

    public void deleteStagedModel(PollsQuestion question) throws PortalException {
        this._pollsQuestionLocalService.deleteQuestion(question);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        PollsQuestion question = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (question != null) {
            this.deleteStagedModel(question);
        }
    }

    public PollsQuestion fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._pollsQuestionLocalService.fetchPollsQuestionByUuidAndGroupId(uuid, groupId);
    }

    public List<PollsQuestion> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._pollsQuestionLocalService.getPollsQuestionsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(PollsQuestion question) {
        return question.getTitle();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, PollsQuestion question) throws Exception {
        Element questionElement = portletDataContext.getExportDataElement((ClassedModel)question);
        portletDataContext.addClassedModel(questionElement, ExportImportPathUtil.getModelPath((StagedModel)question), (ClassedModel)question);
        for (PollsChoice choice : question.getChoices()) {
            Element choiceElement = portletDataContext.getExportDataElement((ClassedModel)choice);
            portletDataContext.addClassedModel(choiceElement, ExportImportPathUtil.getModelPath((StagedModel)choice), (ClassedModel)choice);
        }
        if (portletDataContext.getBooleanParameter("polls", "votes")) {
            for (PollsVote vote : question.getVotes()) {
                Element voteElement = portletDataContext.getExportDataElement((ClassedModel)vote);
                portletDataContext.addClassedModel(voteElement, ExportImportPathUtil.getModelPath((StagedModel)vote), (ClassedModel)vote);
            }
        }
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long questionId) throws Exception {
        PollsQuestion existingQuestion = (PollsQuestion)this.fetchMissingReference(uuid, groupId);
        if (existingQuestion == null) {
            return;
        }
        Map questionIds = portletDataContext.getNewPrimaryKeysMap(PollsQuestion.class);
        questionIds.put(questionId, existingQuestion.getQuestionId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, PollsQuestion question) throws Exception {
        long userId = portletDataContext.getUserId(question.getUserUuid());
        int expirationMonth = 0;
        int expirationDay = 0;
        int expirationYear = 0;
        int expirationHour = 0;
        int expirationMinute = 0;
        boolean neverExpire = true;
        Date expirationDate = question.getExpirationDate();
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar();
            expirationCal.setTime(expirationDate);
            expirationMonth = expirationCal.get(2);
            expirationDay = expirationCal.get(5);
            expirationYear = expirationCal.get(1);
            expirationHour = expirationCal.get(10);
            expirationMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationHour += 12;
            }
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)question);
        PollsQuestion importedQuestion = null;
        if (portletDataContext.isDataStrategyMirror()) {
            PollsQuestion existingQuestion = this.fetchStagedModelByUuidAndGroupId(question.getUuid(), portletDataContext.getScopeGroupId());
            if (existingQuestion == null) {
                serviceContext.setUuid(question.getUuid());
                importedQuestion = this._pollsQuestionLocalService.addQuestion(userId, question.getTitleMap(), question.getDescriptionMap(), expirationMonth, expirationDay, expirationYear, expirationHour, expirationMinute, neverExpire, null, serviceContext);
            } else {
                importedQuestion = this._pollsQuestionLocalService.updateQuestion(userId, existingQuestion.getQuestionId(), question.getTitleMap(), question.getDescriptionMap(), expirationMonth, expirationDay, expirationYear, expirationHour, expirationMinute, neverExpire, question.getChoices(), serviceContext);
            }
        } else {
            importedQuestion = this._pollsQuestionLocalService.addQuestion(userId, question.getTitleMap(), question.getDescriptionMap(), expirationMonth, expirationDay, expirationYear, expirationHour, expirationMinute, neverExpire, null, serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)question, (ClassedModel)importedQuestion);
    }

    @Reference(unbind="-")
    protected void setPollsQuestionLocalService(PollsQuestionLocalService pollsQuestionLocalService) {
        this._pollsQuestionLocalService = pollsQuestionLocalService;
    }
}

