/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.polls.exception.DuplicateVoteException;
import com.liferay.polls.exception.NoSuchQuestionException;
import com.liferay.polls.exception.QuestionExpiredException;
import com.liferay.polls.model.PollsChoice;
import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.model.PollsVote;
import com.liferay.polls.service.base.PollsVoteLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.Date;
import java.util.List;

public class PollsVoteLocalServiceImpl
extends PollsVoteLocalServiceBaseImpl {
    public PollsVote addVote(long userId, long questionId, long choiceId, ServiceContext serviceContext) throws PortalException {
        Date now = new Date();
        PollsChoice choice = this.pollsChoicePersistence.findByPrimaryKey(choiceId);
        if (choice.getQuestionId() != questionId) {
            throw new NoSuchQuestionException("{questionId=" + questionId + "}");
        }
        PollsQuestion question = this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        if (question.isExpired(serviceContext, now)) {
            throw new QuestionExpiredException();
        }
        question.setLastVoteDate(serviceContext.getCreateDate(now));
        this.pollsQuestionPersistence.update((BaseModel)question);
        PollsVote vote = null;
        User user = this.userLocalService.getUser(userId);
        if (!user.isDefaultUser()) {
            vote = this.fetchQuestionUserVote(questionId, userId);
        }
        if (vote != null) {
            StringBundler sb = new StringBundler(5);
            sb.append("{questionId=");
            sb.append(questionId);
            sb.append(", userId=");
            sb.append(userId);
            sb.append("}");
            throw new DuplicateVoteException(sb.toString());
        }
        String userName = user.getFullName();
        if (user.isDefaultUser()) {
            userName = serviceContext.translate("anonymous", new Object[0]);
        }
        long voteId = this.counterLocalService.increment();
        vote = this.pollsVotePersistence.create(voteId);
        vote.setUuid(serviceContext.getUuid());
        vote.setGroupId(serviceContext.getScopeGroupId());
        vote.setCompanyId(serviceContext.getCompanyId());
        vote.setUserId(userId);
        vote.setUserName(userName);
        vote.setQuestionId(questionId);
        vote.setChoiceId(choiceId);
        vote.setVoteDate(serviceContext.getCreateDate(now));
        return (PollsVote)this.pollsVotePersistence.update((BaseModel)vote);
    }

    public PollsVote fetchQuestionUserVote(long questionId, long userId) {
        List votes = this.pollsVotePersistence.findByQ_U(questionId, userId);
        if (votes.isEmpty()) {
            return null;
        }
        return (PollsVote)votes.get(0);
    }

    public List<PollsVote> getChoiceVotes(long choiceId, int start, int end) {
        return this.pollsVotePersistence.findByChoiceId(choiceId, start, end);
    }

    public int getChoiceVotesCount(long choiceId) {
        return this.pollsVotePersistence.countByChoiceId(choiceId);
    }

    public List<PollsVote> getQuestionVotes(long questionId, int start, int end) {
        return this.pollsVotePersistence.findByQuestionId(questionId, start, end);
    }

    public int getQuestionVotesCount(long questionId) {
        return this.pollsVotePersistence.countByQuestionId(questionId);
    }
}

