/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.service.impl;

import com.liferay.polls.model.PollsChoice;
import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.service.base.PollsQuestionServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PollsQuestionServiceImpl
extends PollsQuestionServiceBaseImpl {
    private static volatile ModelResourcePermission<PollsQuestion> _pollsQuestionModelResourcePermission = ModelResourcePermissionFactory.getInstance(PollsQuestionServiceImpl.class, (String)"_pollsQuestionModelResourcePermission", PollsQuestion.class);

    public PollsQuestion addQuestion(Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, List<PollsChoice> choices, ServiceContext serviceContext) throws PortalException {
        PortletResourcePermission portletResourcePermission = _pollsQuestionModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_QUESTION");
        return this.pollsQuestionLocalService.addQuestion(this.getUserId(), titleMap, descriptionMap, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, choices, serviceContext);
    }

    public void deleteQuestion(long questionId) throws PortalException {
        _pollsQuestionModelResourcePermission.check(this.getPermissionChecker(), questionId, "DELETE");
        this.pollsQuestionLocalService.deleteQuestion(questionId);
    }

    public PollsQuestion getQuestion(long questionId) throws PortalException {
        _pollsQuestionModelResourcePermission.check(this.getPermissionChecker(), questionId, "VIEW");
        return this.pollsQuestionLocalService.getQuestion(questionId);
    }

    public PollsQuestion updateQuestion(long questionId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, List<PollsChoice> choices, ServiceContext serviceContext) throws PortalException {
        _pollsQuestionModelResourcePermission.check(this.getPermissionChecker(), questionId, "UPDATE");
        return this.pollsQuestionLocalService.updateQuestion(this.getUserId(), questionId, titleMap, descriptionMap, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, choices, serviceContext);
    }
}

