/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.service.impl;

import com.liferay.polls.exception.QuestionChoiceException;
import com.liferay.polls.model.PollsChoice;
import com.liferay.polls.service.base.PollsChoiceLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;

public class PollsChoiceLocalServiceImpl
extends PollsChoiceLocalServiceBaseImpl {
    public PollsChoice addChoice(long userId, long questionId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this.validate(name, description);
        User user = this.userLocalService.getUser(userId);
        long choiceId = this.counterLocalService.increment();
        PollsChoice choice = this.pollsChoicePersistence.create(choiceId);
        choice.setUuid(serviceContext.getUuid());
        choice.setGroupId(serviceContext.getScopeGroupId());
        choice.setCompanyId(user.getCompanyId());
        choice.setUserId(user.getUserId());
        choice.setUserName(user.getFullName());
        choice.setQuestionId(questionId);
        choice.setName(name);
        choice.setDescription(description);
        return (PollsChoice)this.pollsChoicePersistence.update((BaseModel)choice);
    }

    public PollsChoice getChoice(long choiceId) throws PortalException {
        return this.pollsChoicePersistence.findByPrimaryKey(choiceId);
    }

    public List<PollsChoice> getChoices(long questionId) {
        return this.pollsChoicePersistence.findByQuestionId(questionId);
    }

    public int getChoicesCount(long questionId) {
        return this.pollsChoicePersistence.countByQuestionId(questionId);
    }

    public PollsChoice updateChoice(long choiceId, long questionId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this.validate(name, description);
        this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        PollsChoice choice = this.pollsChoicePersistence.findByPrimaryKey(choiceId);
        choice.setQuestionId(questionId);
        choice.setName(name);
        choice.setDescription(description);
        return (PollsChoice)this.pollsChoicePersistence.update((BaseModel)choice);
    }

    protected void validate(String name, String description) throws PortalException {
        if (Validator.isNull((String)name) || Validator.isNull((String)description)) {
            throw new QuestionChoiceException();
        }
    }
}

