/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.internal.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.service.PollsQuestionLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class PollsQuestionIndexer
extends BaseIndexer<PollsQuestion> {
    public static final String CLASS_NAME = PollsQuestion.class.getName();
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    @Reference
    protected PollsQuestionLocalService pollsQuestionLocalService;
    private static final Log _log = LogFactoryUtil.getLog(PollsQuestionIndexer.class);

    public PollsQuestionIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "createDate", "companyId", "description", "entryClassName", "entryClassPK", "groupId", "scopeGroupId", "title", "uid"});
        this.setFilterSearch(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    protected void doDelete(PollsQuestion pollsQuestion) throws Exception {
        this.deleteDocument(pollsQuestion.getCompanyId(), pollsQuestion.getQuestionId());
    }

    protected Document doGetDocument(PollsQuestion pollsQuestion) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)pollsQuestion);
        document.addDateSortable("createDate", pollsQuestion.getCreateDate());
        document.addText("description", this.getDescriptionField(pollsQuestion));
        document.addText("title", this.getTitleField(pollsQuestion));
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        Summary summary = this.createSummary(document);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(PollsQuestion pollsQuestion) throws Exception {
        Document document = this.getDocument(pollsQuestion);
        this.indexWriterHelper.updateDocument(this.getSearchEngineId(), pollsQuestion.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        PollsQuestion pollsQuestion = this.pollsQuestionLocalService.getPollsQuestion(classPK);
        this.doReindex(pollsQuestion);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexEntries(companyId);
    }

    protected String getDescriptionField(PollsQuestion pollsQuestion) {
        String[] availableLanguageIds = pollsQuestion.getAvailableLanguageIds();
        StringBundler sb = new StringBundler();
        for (String languageId : availableLanguageIds) {
            sb.append(pollsQuestion.getDescription(languageId));
            sb.append(" ");
        }
        return sb.toString();
    }

    protected String getTitleField(PollsQuestion pollsQuestion) {
        String[] availableLanguageIds = pollsQuestion.getAvailableLanguageIds();
        StringBundler sb = new StringBundler();
        for (String languageId : availableLanguageIds) {
            sb.append(pollsQuestion.getTitle(languageId));
            sb.append(" ");
        }
        return sb.toString();
    }

    protected void reindexEntries(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.pollsQuestionLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(pollsQuestion -> {
            block2: {
                try {
                    Document document = this.getDocument(pollsQuestion);
                    indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index Polls Question " + pollsQuestion.getQuestionId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

