/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.internal.exportimport.portlet.preferences.processor;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.polls.exception.NoSuchQuestionException;
import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.service.persistence.PollsQuestionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_polls_web_portlet_PollsDisplayPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class PollsDisplayExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(PollsDisplayExportImportPortletPreferencesProcessor.class);
    @Reference(target="(name=ReferencedStagedModelImporter)")
    private Capability _capability;

    public List<Capability> getExportCapabilities() {
        return null;
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.fromArray((Object[])new Capability[]{this._capability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        String portletId = portletDataContext.getPortletId();
        long questionId = GetterUtil.getLong((String)portletPreferences.getValue("questionId", ""));
        if (questionId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No question ID found in preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        PollsQuestion question = null;
        try {
            question = PollsQuestionUtil.findByPrimaryKey((long)questionId);
        }
        catch (NoSuchQuestionException nsqe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsqe, (Throwable)nsqe);
            }
            return portletPreferences;
        }
        try {
            portletDataContext.addPortletPermissions("com.liferay.polls");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to export portlet permissions", (Throwable)pe);
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)question);
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.importPortletPermissions("com.liferay.polls");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to import portlet permissions", (Throwable)pe);
        }
        long questionId = GetterUtil.getLong((String)portletPreferences.getValue("questionId", ""));
        if (questionId > 0L) {
            Map questionIds = portletDataContext.getNewPrimaryKeysMap(PollsQuestion.class);
            questionId = MapUtil.getLong((Map)questionIds, (long)questionId, (long)questionId);
            try {
                portletPreferences.setValue("questionId", String.valueOf(questionId));
            }
            catch (ReadOnlyException roe) {
                throw new PortletDataException("Unable to update portlet preferences during import", (Throwable)roe);
            }
        }
        return portletPreferences;
    }
}

