/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.polls.exception.DuplicateVoteException;
import com.liferay.polls.model.PollsChoice;
import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.model.PollsVote;
import com.liferay.polls.service.PollsVoteLocalService;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class PollsVoteStagedModelDataHandler
extends BaseStagedModelDataHandler<PollsVote> {
    public static final String[] CLASS_NAMES = new String[]{PollsVote.class.getName()};
    private PollsVoteLocalService _pollsVoteLocalService;

    public void deleteStagedModel(PollsVote vote) {
        this._pollsVoteLocalService.deletePollsVote(vote);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        PollsVote vote = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (vote != null) {
            this.deleteStagedModel(vote);
        }
    }

    public PollsVote fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._pollsVoteLocalService.fetchPollsVoteByUuidAndGroupId(uuid, groupId);
    }

    public List<PollsVote> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._pollsVoteLocalService.getPollsVotesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, PollsVote vote) throws Exception {
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)vote, (StagedModel)vote.getChoice(), (String)"strong");
        Element voteElement = portletDataContext.getExportDataElement((ClassedModel)vote);
        portletDataContext.addClassedModel(voteElement, ExportImportPathUtil.getModelPath((StagedModel)vote), (ClassedModel)vote);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long voteId) throws Exception {
        PollsVote existingVote = (PollsVote)this.fetchMissingReference(uuid, groupId);
        if (existingVote == null) {
            return;
        }
        Map voteIds = portletDataContext.getNewPrimaryKeysMap(PollsVote.class);
        voteIds.put(voteId, existingVote.getVoteId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, PollsVote vote) throws Exception {
        PollsVote existingVote;
        Map questionIds = portletDataContext.getNewPrimaryKeysMap(PollsQuestion.class);
        long questionId = MapUtil.getLong((Map)questionIds, (long)vote.getQuestionId(), (long)vote.getQuestionId());
        Map choiceIds = portletDataContext.getNewPrimaryKeysMap(PollsChoice.class);
        long choiceId = MapUtil.getLong((Map)choiceIds, (long)vote.getChoiceId(), (long)vote.getChoiceId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)vote);
        serviceContext.setCreateDate(vote.getCreateDate());
        if (portletDataContext.isDataStrategyMirror() && (existingVote = this.fetchStagedModelByUuidAndGroupId(vote.getUuid(), portletDataContext.getScopeGroupId())) == null) {
            serviceContext.setUuid(vote.getUuid());
        }
        try {
            this._pollsVoteLocalService.addVote(vote.getUserId(), questionId, choiceId, serviceContext);
        }
        catch (DuplicateVoteException duplicateVoteException) {
            // empty catch block
        }
    }

    @Reference(unbind="-")
    protected void setPollsVoteLocalService(PollsVoteLocalService pollsVoteLocalService) {
        this._pollsVoteLocalService = pollsVoteLocalService;
    }
}

