/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.polls.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.polls.model.PollsChoice;
import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.service.PollsChoiceLocalService;
import com.liferay.polls.service.PollsQuestionLocalService;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class PollsChoiceStagedModelDataHandler
extends BaseStagedModelDataHandler<PollsChoice> {
    public static final String[] CLASS_NAMES = new String[]{PollsChoice.class.getName()};
    private PollsChoiceLocalService _pollsChoiceLocalService;
    private PollsQuestionLocalService _pollsQuestionLocalService;

    public void deleteStagedModel(PollsChoice choice) {
        this._pollsChoiceLocalService.deletePollsChoice(choice);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        PollsChoice pollsChoice = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (pollsChoice != null) {
            this.deleteStagedModel(pollsChoice);
        }
    }

    public PollsChoice fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._pollsChoiceLocalService.fetchPollsChoiceByUuidAndGroupId(uuid, groupId);
    }

    public List<PollsChoice> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._pollsChoiceLocalService.getPollsChoicesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(PollsChoice choice) {
        return choice.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, PollsChoice choice) throws Exception {
        PollsQuestion question = this._pollsQuestionLocalService.getQuestion(choice.getQuestionId());
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)choice, (StagedModel)question, (String)"strong");
        Element choiceElement = portletDataContext.getExportDataElement((ClassedModel)choice);
        portletDataContext.addClassedModel(choiceElement, ExportImportPathUtil.getModelPath((StagedModel)choice), (ClassedModel)choice);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long choiceId) throws Exception {
        PollsChoice existingChoice = (PollsChoice)this.fetchMissingReference(uuid, groupId);
        if (existingChoice == null) {
            return;
        }
        Map choiceIds = portletDataContext.getNewPrimaryKeysMap(PollsChoice.class);
        choiceIds.put(choiceId, existingChoice.getChoiceId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, PollsChoice choice) throws Exception {
        long userId = portletDataContext.getUserId(choice.getUserUuid());
        Map questionIds = portletDataContext.getNewPrimaryKeysMap(PollsQuestion.class);
        long questionId = MapUtil.getLong((Map)questionIds, (long)choice.getQuestionId(), (long)choice.getQuestionId());
        PollsChoice importedChoice = null;
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)choice);
        if (portletDataContext.isDataStrategyMirror()) {
            PollsChoice existingChoice = this.fetchStagedModelByUuidAndGroupId(choice.getUuid(), portletDataContext.getScopeGroupId());
            if (existingChoice == null) {
                serviceContext.setUuid(choice.getUuid());
                importedChoice = this._pollsChoiceLocalService.addChoice(userId, questionId, choice.getName(), choice.getDescription(), serviceContext);
            } else {
                importedChoice = this._pollsChoiceLocalService.updateChoice(existingChoice.getChoiceId(), questionId, choice.getName(), choice.getDescription(), serviceContext);
            }
        } else {
            importedChoice = this._pollsChoiceLocalService.addChoice(userId, questionId, choice.getName(), choice.getDescription(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)choice, (ClassedModel)importedChoice);
    }

    @Reference(unbind="-")
    protected void setPollsChoiceLocalService(PollsChoiceLocalService pollsChoiceLocalService) {
        this._pollsChoiceLocalService = pollsChoiceLocalService;
    }

    @Reference(unbind="-")
    protected void setPollsQuestionLocalService(PollsQuestionLocalService pollsQuestionLocalService) {
        this._pollsQuestionLocalService = pollsQuestionLocalService;
    }
}

