/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.polls.model.impl;

import com.liferay.polls.model.PollsQuestion;
import com.liferay.polls.service.PollsQuestionLocalServiceUtil;

/**
 * The extended model base implementation for the PollsQuestion service. Represents a row in the &quot;PollsQuestion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PollsQuestionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see PollsQuestionImpl
 * @see PollsQuestion
 * @generated
 */
public abstract class PollsQuestionBaseImpl
	extends PollsQuestionModelImpl implements PollsQuestion {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a polls question model instance should use the <code>PollsQuestion</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			PollsQuestionLocalServiceUtil.addPollsQuestion(this);
		}
		else {
			PollsQuestionLocalServiceUtil.updatePollsQuestion(this);
		}
	}

}