/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.map;

import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerCustomizerFactory {
    public static <S, T> Function<BundleContext, ServiceTrackerCustomizer<S, T>> createFromFunction(BiFunction<ServiceReference<S>, S, T> function) {
        return b -> new ServiceTrackerCustomizer<S, T>((BundleContext)b, function){
            final /* synthetic */ BundleContext val$b;
            final /* synthetic */ BiFunction val$function;
            {
                this.val$b = bundleContext;
                this.val$function = biFunction;
            }

            public T addingService(ServiceReference<S> serviceReference) {
                Object service = this.val$b.getService(serviceReference);
                try {
                    return this.val$function.apply(serviceReference, service);
                }
                catch (Exception e) {
                    this.val$b.ungetService(serviceReference);
                    throw e;
                }
            }

            public void modifiedService(ServiceReference<S> serviceReference, T t) {
                this.removedService(serviceReference, t);
                this.addingService(serviceReference);
            }

            public void removedService(ServiceReference<S> serviceReference, T t) {
                this.val$b.ungetService(serviceReference);
            }
        };
    }

    public static <S> ServiceTrackerCustomizer<S, ServiceReferenceServiceTuple<S, S>> serviceReferenceServiceTuple(final BundleContext bundleContext) {
        return new ServiceTrackerCustomizer<S, ServiceReferenceServiceTuple<S, S>>(){

            public ServiceReferenceServiceTuple<S, S> addingService(ServiceReference<S> serviceReference) {
                Object service = bundleContext.getService(serviceReference);
                if (service == null) {
                    return null;
                }
                return new ServiceReferenceServiceTuple(serviceReference, service);
            }

            public void modifiedService(ServiceReference<S> serviceReference, ServiceReferenceServiceTuple<S, S> serviceReferenceServiceTuple) {
            }

            public void removedService(ServiceReference<S> serviceReference, ServiceReferenceServiceTuple<S, S> serviceReferenceServiceTuple) {
                bundleContext.ungetService(serviceReference);
            }
        };
    }

    public static <S> ServiceTrackerCustomizer<S, ServiceWrapper<S>> serviceWrapper(final BundleContext bundleContext) {
        return new ServiceTrackerCustomizer<S, ServiceWrapper<S>>(){

            public ServiceWrapper<S> addingService(ServiceReference<S> serviceReference) {
                Object service = bundleContext.getService(serviceReference);
                if (service == null) {
                    return null;
                }
                try {
                    return new ServiceWrapperImpl(serviceReference, service);
                }
                catch (Throwable t) {
                    bundleContext.ungetService(serviceReference);
                    throw t;
                }
            }

            public void modifiedService(ServiceReference<S> serviceReference, ServiceWrapper<S> serviceWrapper) {
                ServiceWrapperImpl serviceWrapperImpl = (ServiceWrapperImpl)serviceWrapper;
                serviceWrapperImpl._resetProperties();
            }

            public void removedService(ServiceReference<S> serviceReference, ServiceWrapper<S> serviceWrapper) {
                bundleContext.ungetService(serviceReference);
            }
        };
    }

    private static class ServiceWrapperImpl<S>
    implements ServiceWrapper<S> {
        private volatile Map<String, Object> _properties;
        private final S _service;
        private final ServiceReference<S> _serviceReference;

        @Override
        public Map<String, Object> getProperties() {
            Map<String, Object> properties = this._properties;
            if (properties == null) {
                String[] propertyKeys;
                properties = new HashMap<String, Object>();
                for (String propertyKey : propertyKeys = this._serviceReference.getPropertyKeys()) {
                    properties.put(propertyKey, this._serviceReference.getProperty(propertyKey));
                }
                this._properties = properties;
            }
            return properties;
        }

        @Override
        public S getService() {
            return this._service;
        }

        private ServiceWrapperImpl(ServiceReference<S> serviceReference, S service) {
            this._serviceReference = serviceReference;
            this._service = service;
        }

        private void _resetProperties() {
            this._properties = null;
        }
    }

    public static interface ServiceWrapper<S> {
        public Map<String, Object> getProperties();

        public S getService();
    }
}

