/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.trash;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.trash.BaseTrashHandler;
import jakarta.portlet.PortletRequest;

public class ObjectEntryTrashHandler
extends BaseTrashHandler {
    private final ObjectDefinition _objectDefinition;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryService _objectEntryService;
    private final SystemEventLocalService _systemEventLocalService;

    public ObjectEntryTrashHandler(ObjectDefinition objectDefinition, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryService objectEntryService, SystemEventLocalService systemEventLocalService) {
        this._objectDefinition = objectDefinition;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryService = objectEntryService;
        this._systemEventLocalService = systemEventLocalService;
    }

    public SystemEvent addDeletionSystemEvent(long userId, long groupId, long classPK, String classUuid, String referrerClassName) throws PortalException {
        ObjectEntry objectEntry = this._objectEntryService.getObjectEntry(classPK);
        return this._systemEventLocalService.addSystemEvent(userId, groupId, objectEntry.getExternalReferenceCode(), this.getSystemEventClassName(), classPK, classUuid, referrerClassName, 1, "");
    }

    public void deleteTrashEntry(long classPK) throws PortalException {
        this._objectEntryService.deleteObjectEntry(classPK);
    }

    public String getClassName() {
        return this._objectDefinition.getClassName();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        return null;
    }

    public TrashedModel getTrashedModel(long classPK) {
        try {
            return this._objectEntryService.fetchObjectEntry(classPK);
        }
        catch (PortalException portalException) {
            return (TrashedModel)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        ModelResourcePermission modelResourcePermission = this._objectEntryService.getModelResourcePermission(this._objectDefinition.getObjectDefinitionId());
        return modelResourcePermission.contains(permissionChecker, classPK, actionId);
    }
}

