/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.internal.field.business.type.BaseObjectFieldBusinessType;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=AutoIncrement"}, service={ObjectFieldBusinessType.class})
public class AutoIncrementObjectFieldBusinessType
extends BaseObjectFieldBusinessType {
    private static final int _MAX_LENGTH = 50;
    private static final Log _log = LogFactoryUtil.getLog(AutoIncrementObjectFieldBusinessType.class);
    private static final Pattern _pattern = Pattern.compile("^[A-Za-z0-9\\s-\\/:,.\\(\\)\\[\\]\\{\\}#$%+]*$");
    @Reference
    private Language _language;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"prefix", "suffix"});
    }

    public String getDBType() {
        return "String";
    }

    public String getDDMFormFieldTypeName() {
        return "auto-increment";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "automatically-generate-a-unique-value-when-a-new-entry-is-added");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "auto-increment");
    }

    public String getName() {
        return "AutoIncrement";
    }

    @Override
    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        Map<String, Object> properties = super.getProperties(objectField, objectFieldRenderingContext);
        properties.remove("initialValue");
        return properties;
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.TEXT;
    }

    public Set<String> getRequiredObjectFieldSettingsNames(ObjectField objectField) {
        return Collections.singleton("initialValue");
    }

    public Set<String> getUnmodifiableObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"initialValue", "prefix", "suffix"});
    }

    public boolean isLocalizationSupported(ObjectField objectField) {
        return false;
    }

    public void validateObjectFieldSettings(ObjectField objectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        long initialValue;
        Map<String, String> objectFieldSettingsValues;
        block3: {
            super.validateObjectFieldSettings(objectField, objectFieldSettings);
            objectFieldSettingsValues = this.getObjectFieldSettingsValues(objectFieldSettings);
            this.validateMaxLength(50, "prefix", objectFieldSettingsValues.get("prefix"));
            this.validateMaxLength(50, "suffix", objectFieldSettingsValues.get("suffix"));
            this._validatePattern(objectField.getName(), "prefix", objectFieldSettingsValues.get("prefix"));
            this._validatePattern(objectField.getName(), "suffix", objectFieldSettingsValues.get("suffix"));
            initialValue = 0L;
            try {
                initialValue = Long.parseUnsignedLong(objectFieldSettingsValues.get("initialValue"));
            }
            catch (NumberFormatException numberFormatException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)numberFormatException);
            }
        }
        if (initialValue == 0L) {
            throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "initialValue", objectFieldSettingsValues.get("initialValue"));
        }
    }

    private void _validatePattern(String objectFieldName, String objectFieldSettingName, String objectFieldSettingValue) throws PortalException {
        if (Validator.isNull((String)objectFieldSettingValue)) {
            return;
        }
        Matcher matcher = _pattern.matcher(objectFieldSettingValue);
        if (matcher.matches()) {
            return;
        }
        throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, objectFieldSettingName, objectFieldSettingValue);
    }
}

