/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectFieldSettingLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectFieldSetting service. Represents a row in the &quot;ObjectFieldSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectFieldSettingImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectFieldSettingImpl
 * @see ObjectFieldSetting
 * @generated
 */
public abstract class ObjectFieldSettingBaseImpl
	extends ObjectFieldSettingModelImpl implements ObjectFieldSetting {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object field setting model instance should use the <code>ObjectFieldSetting</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectFieldSettingLocalServiceUtil.addObjectFieldSetting(this);
		}
		else {
			ObjectFieldSettingLocalServiceUtil.updateObjectFieldSetting(this);
		}
	}

}