/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectFolderItem;
import com.liferay.object.model.ObjectFolderItemTable;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.service.base.ObjectFolderItemLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectFolderPersistence;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectFolderItem"}, service={AopService.class})
public class ObjectFolderItemLocalServiceImpl
extends ObjectFolderItemLocalServiceBaseImpl {
    @Reference
    private InlineSQLHelper _inlineSQLHelper;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFolderPersistence _objectFolderPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public ObjectFolderItem addObjectFolderItem(long userId, long objectDefinitionId, long objectFolderId, int positionX, int positionY) throws PortalException {
        this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._objectFolderPersistence.findByPrimaryKey(objectFolderId);
        ObjectFolderItem objectFolderItem = this.objectFolderItemPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectFolderItem.setCompanyId(user.getCompanyId());
        objectFolderItem.setUserId(user.getUserId());
        objectFolderItem.setUserName(user.getFullName());
        objectFolderItem.setObjectDefinitionId(objectDefinitionId);
        objectFolderItem.setObjectFolderId(objectFolderId);
        objectFolderItem.setPositionX(positionX);
        objectFolderItem.setPositionY(positionY);
        return (ObjectFolderItem)this.objectFolderItemPersistence.update((BaseModel)objectFolderItem);
    }

    public ObjectFolderItem deleteObjectFolderItem(long objectDefinitionId, long objectFolderId) throws PortalException {
        ObjectFolderItem objectFolderItem = this.objectFolderItemPersistence.findByODI_OFI(objectDefinitionId, objectFolderId);
        return this.objectFolderItemLocalService.deleteObjectFolderItem(objectFolderItem);
    }

    @Override
    public ObjectFolderItem deleteObjectFolderItem(ObjectFolderItem objectFolderItem) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectFolderItem.getObjectDefinitionId());
        if (!objectDefinition.isLinkedToObjectFolder(objectFolderItem.getObjectFolderId())) {
            return objectFolderItem;
        }
        for (ObjectDefinition relatedObjectDefinition : ObjectRelationshipUtil.getRelatedObjectDefinitions((ObjectDefinition)objectDefinition)) {
            if (relatedObjectDefinition.isLinkedToObjectFolder(objectFolderItem.getObjectFolderId())) continue;
            return objectFolderItem;
        }
        return (ObjectFolderItem)this.objectFolderItemPersistence.remove((BaseModel)objectFolderItem);
    }

    public void deleteObjectFolderItemByObjectDefinitionId(long objectDefinitionId) {
        List objectFolderItems = this.objectFolderItemPersistence.findByObjectDefinitionId(objectDefinitionId);
        for (ObjectFolderItem objectFolderItem : objectFolderItems) {
            this.objectFolderItemPersistence.remove((BaseModel)objectFolderItem);
        }
    }

    public void deleteObjectFolderItemByObjectFolderId(long objectFolderId) {
        List objectFolderItems = this.objectFolderItemPersistence.findByObjectFolderId(objectFolderId);
        for (ObjectFolderItem objectFolderItem : objectFolderItems) {
            this.objectFolderItemPersistence.remove((BaseModel)objectFolderItem);
        }
    }

    public ObjectFolderItem fetchObjectFolderItem(long objectDefinitionId, long objectFolderId) {
        return this.objectFolderItemPersistence.fetchByODI_OFI(objectDefinitionId, objectFolderId);
    }

    public ObjectFolderItem getObjectFolderItem(long objectDefinitionId, long objectFolderId) throws PortalException {
        return this.objectFolderItemPersistence.findByODI_OFI(objectDefinitionId, objectFolderId);
    }

    public List<ObjectFolderItem> getObjectFolderItemsByObjectDefinitionId(long objectDefinitionId) {
        return this.objectFolderItemPersistence.findByObjectDefinitionId(objectDefinitionId);
    }

    public List<ObjectFolderItem> getObjectFolderItemsByObjectFolderId(long objectFolderId) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.select((Table)ObjectFolderItemTable.INSTANCE).from((Table)ObjectFolderItemTable.INSTANCE).where(() -> {
            Predicate predicate = ObjectFolderItemTable.INSTANCE.objectFolderId.eq((Object)objectFolderId);
            if (PermissionThreadLocal.getPermissionChecker() == null || !this._inlineSQLHelper.isEnabled()) {
                return predicate;
            }
            Predicate permissionWherePredicate = this._inlineSQLHelper.getPermissionWherePredicate(ObjectDefinition.class.getName(), ObjectFolderItemTable.INSTANCE.objectDefinitionId, new long[0]);
            if (permissionWherePredicate != null) {
                predicate = predicate.and((Expression)permissionWherePredicate);
            }
            return predicate;
        });
        return (List)this.dslQuery((DSLQuery)dslQuery);
    }

    public ObjectFolderItem updateObjectFolderItem(long objectDefinitionId, long objectFolderId, int positionX, int positionY) throws PortalException {
        ObjectFolderItem objectFolderItem = this.objectFolderItemPersistence.findByODI_OFI(objectDefinitionId, objectFolderId);
        objectFolderItem.setPositionX(positionX);
        objectFolderItem.setPositionY(positionY);
        return (ObjectFolderItem)this.objectFolderItemPersistence.update((BaseModel)objectFolderItem);
    }

    public void updateObjectFolderObjectFolderItem(long objectDefinitionId, long newObjectFolderId, long oldObjectFolderId) throws PortalException {
        if (newObjectFolderId == oldObjectFolderId) {
            return;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._updateObjectFolderObjectFolderItem(objectDefinitionId, newObjectFolderId, oldObjectFolderId, objectDefinition.getUserId());
        for (ObjectDefinition relatedObjectDefinition : ObjectRelationshipUtil.getRelatedObjectDefinitions((ObjectDefinition)objectDefinition)) {
            this._updateObjectFolderObjectFolderItem(relatedObjectDefinition.getObjectDefinitionId(), newObjectFolderId, oldObjectFolderId, objectDefinition.getUserId());
        }
    }

    private void _updateObjectFolderObjectFolderItem(long objectDefinitionId, long newObjectFolderId, long oldObjectFolderId, long userId) throws PortalException {
        this.objectFolderItemLocalService.deleteObjectFolderItem(objectDefinitionId, oldObjectFolderId);
        ObjectFolderItem objectFolderItem = this.objectFolderItemPersistence.fetchByODI_OFI(objectDefinitionId, newObjectFolderId);
        if (objectFolderItem != null) {
            return;
        }
        this.objectFolderItemLocalService.addObjectFolderItem(userId, objectDefinitionId, newObjectFolderId, 0, 0);
    }
}

