/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    @Reference
    private Language _language;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterRemove(User user) throws ModelListenerException {
        try {
            User defaultServiceAccountUser = this._userLocalService.fetchUserByScreenName(user.getCompanyId(), "default-service-account");
            if (defaultServiceAccountUser == null) {
                return;
            }
            this._objectDefinitionLocalService.updateUserId(user.getCompanyId(), user.getUserId(), defaultServiceAccountUser.getUserId());
            this._objectFieldLocalService.updateUserId(user.getCompanyId(), user.getUserId(), defaultServiceAccountUser.getUserId());
            this._objectRelationshipLocalService.updateUserId(user.getCompanyId(), user.getUserId(), defaultServiceAccountUser.getUserId());
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onAfterUpdate(User originalUser, User user) throws ModelListenerException {
        if (!user.isGuestUser()) {
            return;
        }
        Locale locale = user.getLocale();
        if (Objects.equals(originalUser.getLocale(), locale)) {
            return;
        }
        for (ObjectDefinition systemObjectDefinition : this._objectDefinitionLocalService.getObjectDefinitions(user.getCompanyId(), true, true, 0)) {
            SystemObjectDefinitionManager systemObjectDefinitionManager;
            Map labelMap = systemObjectDefinition.getLabelMap();
            if (labelMap.containsKey(locale) || (systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(systemObjectDefinition.getName())) == null) continue;
            Map labelKeys = systemObjectDefinitionManager.getLabelKeys();
            systemObjectDefinition.setLabel(this._language.get(locale, (String)labelKeys.get("label")), locale);
            systemObjectDefinition.setPluralLabel(this._language.get(locale, (String)labelKeys.get("pluralLabel")), locale);
            this._objectDefinitionLocalService.updateObjectDefinition(systemObjectDefinition);
        }
    }
}

