/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectState;
import com.liferay.object.model.ObjectStateFlow;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.service.ObjectStateFlowLocalService;
import com.liferay.object.service.ObjectStateLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Picklist"}, service={ObjectFieldBusinessType.class})
public class PicklistObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectStateFlowLocalService _objectStateFlowLocalService;
    @Reference
    private ObjectStateLocalService _objectStateLocalService;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"defaultValue", "defaultValueType", "stateFlow"});
    }

    public String getDBType() {
        return "String";
    }

    public String getDDMFormFieldTypeName() {
        return "select";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "choose-from-a-picklist");
    }

    public Object getDisplayContextValue(ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        if (objectField.isLocalized()) {
            return this.getLocalizedValues(objectField, userId, values);
        }
        return super.getDisplayContextValue(objectField, userId, values);
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "picklist");
    }

    public Map<String, Object> getLocalizedValues(ObjectField objectField, Long userId, Map<String, Object> values) throws PortalException {
        Map localizedValues = super.getLocalizedValues(objectField, userId, values);
        if (localizedValues == null) {
            return null;
        }
        for (Map.Entry entry : localizedValues.entrySet()) {
            localizedValues.put((String)entry.getKey(), this._getValue(objectField.getName(), entry.getValue(), new HashMap<String, Object>()));
        }
        return localizedValues;
    }

    public String getName() {
        return "Picklist";
    }

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        return HashMapBuilder.put((Object)"listTypeDefinitionId", (Object)objectField.getListTypeDefinitionId()).put((Object)"options", (Object)this._getDDMFormFieldOptions(objectField, objectFieldRenderingContext)).put((Object)"predefinedValue", () -> {
            LocalizedValue localizedValue = new LocalizedValue(objectFieldRenderingContext.getLocale());
            Locale defaultLocale = objectFieldRenderingContext.getLocale();
            String defaultValue = String.valueOf(ObjectFieldSettingUtil.getDefaultValue(null, (ObjectField)objectField, null));
            if (objectField.isLocalized() && Validator.isNotNull((String)defaultValue)) {
                localizedValue.addString(defaultLocale, this._jsonFactory.createJSONObject((Map)HashMapBuilder.put((Object)defaultLocale, (Object)defaultValue).build()).toJSONString());
            } else {
                localizedValue.addString(defaultLocale, defaultValue);
            }
            return localizedValue;
        }).putAll(super.getProperties(objectField, objectFieldRenderingContext)).build();
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.TEXT;
    }

    public Set<String> getRequiredObjectFieldSettingsNames(ObjectField objectField) {
        if (!objectField.isState()) {
            return Collections.emptySet();
        }
        return SetUtil.fromArray((Object[])new String[]{"defaultValue", "defaultValueType"});
    }

    public Object getValue(ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        return this._getValue(objectField.getName(), super.getValue(objectField, userId, values), values);
    }

    public void predefineObjectFieldSettings(ObjectField newObjectField, ObjectField oldObjectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        for (ObjectFieldSetting objectFieldSetting : objectFieldSettings) {
            if (!StringUtil.equals((String)objectFieldSetting.getName(), (String)"stateFlow") || objectFieldSetting.getObjectStateFlow() == null) continue;
            ObjectStateFlow newObjectStateFlow = objectFieldSetting.getObjectStateFlow();
            if (oldObjectField != null) {
                ObjectStateFlow oldObjectStateFlow = this._objectStateFlowLocalService.fetchObjectFieldObjectStateFlow(oldObjectField.getObjectFieldId());
                this._objectStateFlowLocalService.updateObjectStateFlow(newObjectField.getUserId(), oldObjectStateFlow.getObjectStateFlowId(), newObjectStateFlow.getObjectStates());
                this._objectStateFlowLocalService.updateDefaultObjectStateFlow(newObjectField, oldObjectField);
            } else {
                this._objectStateFlowLocalService.addObjectStateFlow(newObjectField.getUserId(), newObjectField.getObjectFieldId(), newObjectStateFlow.getObjectStates());
            }
            return;
        }
        this._objectStateFlowLocalService.addDefaultObjectStateFlow(newObjectField);
    }

    public void validateObjectFieldSettingsDefaultValue(ObjectField objectField, Map<String, String> objectFieldSettingsValuesMap) throws PortalException {
        if (objectFieldSettingsValuesMap.isEmpty()) {
            return;
        }
        super.validateObjectFieldSettingsDefaultValue(objectField, objectFieldSettingsValuesMap);
        String defaultValueType = objectFieldSettingsValuesMap.get("defaultValueType");
        if (StringUtil.equals((String)defaultValueType, (String)"expressionBuilder")) {
            if (objectField.isState()) {
                throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "defaultValueType", defaultValueType);
            }
            return;
        }
        String defaultValue = objectFieldSettingsValuesMap.get("defaultValue");
        if (defaultValue == null) {
            return;
        }
        ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(objectField.getListTypeDefinitionId(), defaultValue);
        if (listTypeEntry == null) {
            throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "defaultValue", defaultValue);
        }
    }

    private DDMFormFieldOptions _getDDMFormFieldOptions(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions(objectFieldRenderingContext.getLocale());
        for (ListTypeEntry listTypeEntry : this._getListTypeEntries(objectField, objectFieldRenderingContext)) {
            Map nameMap = listTypeEntry.getNameMap();
            for (Map.Entry entry : nameMap.entrySet()) {
                ddmFormFieldOptions.addOptionLabel(listTypeEntry.getKey(), (Locale)entry.getKey(), GetterUtil.getString((String)((String)entry.getValue())));
            }
        }
        return ddmFormFieldOptions;
    }

    private List<ListTypeEntry> _getListTypeEntries(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        ListTypeEntry listTypeEntry;
        if (!objectField.isState()) {
            return this._listTypeEntryLocalService.getListTypeEntries(objectField.getListTypeDefinitionId());
        }
        String listEntryKey = String.valueOf(ObjectFieldSettingUtil.getDefaultValue(null, (ObjectField)objectField, null));
        if (MapUtil.isNotEmpty((Map)objectFieldRenderingContext.getProperties())) {
            ListEntry listEntry = (ListEntry)objectFieldRenderingContext.getProperty(objectField.getName());
            if (listEntry == null || Validator.isNull((String)listEntry.getKey())) {
                return this._listTypeEntryLocalService.getListTypeEntries(objectField.getListTypeDefinitionId());
            }
            listEntryKey = listEntry.getKey();
        }
        if ((listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(objectField.getListTypeDefinitionId(), listEntryKey)) == null) {
            return Collections.emptyList();
        }
        ObjectStateFlow objectStateFlow = this._objectStateFlowLocalService.fetchObjectFieldObjectStateFlow(objectField.getObjectFieldId());
        ObjectState objectState = this._objectStateLocalService.getObjectStateFlowObjectState(listTypeEntry.getListTypeEntryId(), objectStateFlow.getObjectStateFlowId());
        List listTypeEntries = TransformUtil.transform((Collection)this._objectStateLocalService.getNextObjectStates(objectState.getObjectStateId()), nextObjectState -> this._listTypeEntryLocalService.getListTypeEntry(nextObjectState.getListTypeEntryId()));
        listTypeEntries.add(this._listTypeEntryLocalService.getListTypeEntry(objectState.getListTypeEntryId()));
        return listTypeEntries;
    }

    private Object _getValue(String objectFieldName, Object value, Map<String, Object> values) {
        if (value instanceof ListEntry) {
            ListEntry listEntry = (ListEntry)value;
            values.put(objectFieldName, listEntry.getKey());
            return listEntry.getKey();
        }
        if (value instanceof Map) {
            String key = MapUtil.getString((Map)((Map)value), (Object)"key");
            values.put(objectFieldName, key);
            return key;
        }
        return value;
    }
}

