/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.service.impl;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.service.base.NotificationTemplateServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=notification", "json.web.service.context.path=NotificationTemplate"}, service={AopService.class})
public class NotificationTemplateServiceImpl
extends NotificationTemplateServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.notification.model.NotificationTemplate)")
    private ModelResourcePermission<NotificationTemplate> _notificationTemplateModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.notification.template)")
    private PortletResourcePermission _portletResourcePermission;

    public NotificationTemplate addNotificationTemplate(NotificationContext notificationContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_NOTIFICATION_TEMPLATE");
        return this.notificationTemplateLocalService.addNotificationTemplate(notificationContext);
    }

    public NotificationTemplate deleteNotificationTemplate(long notificationTemplateId) throws PortalException {
        this._notificationTemplateModelResourcePermission.check(this.getPermissionChecker(), notificationTemplateId, "DELETE");
        return this.notificationTemplateLocalService.deleteNotificationTemplate(notificationTemplateId);
    }

    public NotificationTemplate deleteNotificationTemplate(NotificationTemplate notificationTemplate) throws PortalException {
        this._notificationTemplateModelResourcePermission.check(this.getPermissionChecker(), notificationTemplate.getNotificationTemplateId(), "DELETE");
        return this.notificationTemplateLocalService.deleteNotificationTemplate(notificationTemplate);
    }

    public NotificationTemplate fetchNotificationTemplateByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        NotificationTemplate notificationTemplate = this.notificationTemplateLocalService.fetchNotificationTemplateByExternalReferenceCode(externalReferenceCode, companyId);
        if (notificationTemplate != null) {
            this._notificationTemplateModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)notificationTemplate, "VIEW");
        }
        return notificationTemplate;
    }

    public NotificationTemplate getNotificationTemplate(long notificationTemplateId) throws PortalException {
        this._notificationTemplateModelResourcePermission.check(this.getPermissionChecker(), notificationTemplateId, "VIEW");
        return this.notificationTemplateLocalService.getNotificationTemplate(notificationTemplateId);
    }

    public NotificationTemplate updateNotificationTemplate(NotificationContext notificationContext) throws PortalException {
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        this._notificationTemplateModelResourcePermission.check(this.getPermissionChecker(), notificationTemplate.getNotificationTemplateId(), "UPDATE");
        return this.notificationTemplateLocalService.updateNotificationTemplate(notificationContext);
    }
}

