/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.email.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.email.provider.EmailProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.HashSet;

public class SubscribersEmailProvider
implements EmailProvider {
    private final SubscriptionLocalService _subscriptionLocalService;
    private final UserLocalService _userLocalService;

    public SubscribersEmailProvider(SubscriptionLocalService subscriptionLocalService, UserLocalService userLocalService) {
        this._subscriptionLocalService = subscriptionLocalService;
        this._userLocalService = userLocalService;
    }

    @Override
    public String provide(NotificationContext notificationContext, Object value) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-42577")) {
            return null;
        }
        HashSet<String> emailAddresses = new HashSet<String>();
        for (Subscription subscription : this._subscriptionLocalService.getSubscriptions(notificationContext.getCompanyId(), notificationContext.getClassName(), notificationContext.getClassPK())) {
            User user = this._userLocalService.fetchUser(subscription.getUserId());
            emailAddresses.add(user.getEmailAddress());
        }
        return StringUtil.merge(emailAddresses);
    }
}

