/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.users.provider.DefaultUsersProvider;
import com.liferay.notification.internal.type.users.provider.RoleUsersProvider;
import com.liferay.notification.internal.type.users.provider.TermUsersProvider;
import com.liferay.notification.internal.type.users.provider.UsersProvider;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.type.BaseNotificationType;
import com.liferay.notification.type.NotificationType;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NotificationType.class})
public class UserNotificationType
extends BaseNotificationType {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ObjectEntryService _objectEntryService;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;
    private final Map<String, UsersProvider> _usersProviders = new HashMap<String, UsersProvider>();

    public NotificationQueueEntry createNotificationQueueEntry(User user, String body, NotificationContext notificationContext, String subject) {
        NotificationQueueEntry notificationQueueEntry = super.createNotificationQueueEntry(user, body, notificationContext, subject);
        notificationQueueEntry.setStatus(1);
        return notificationQueueEntry;
    }

    public Set<String> getAllowedNotificationRecipientSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"roleName", "term", "userScreenName"});
    }

    public String getRecipientSummary(NotificationQueueEntry notificationQueueEntry) {
        NotificationRecipient notificationRecipient = notificationQueueEntry.getNotificationRecipient();
        ArrayList<String> values = new ArrayList<String>();
        for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
            values.add(notificationRecipientSetting.getValue());
        }
        return ListUtil.toString(values, (String)null, (String)", ");
    }

    public String getType() {
        return "userNotification";
    }

    public String getTypeLanguageKey() {
        return "user-notification";
    }

    public void sendNotification(NotificationContext notificationContext) throws PortalException {
        boolean enqueue = false;
        ArrayList<HashMap> notificationRecipientSettings = new ArrayList<HashMap>();
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        UsersProvider usersProvider = this._usersProviders.get(notificationTemplate.getRecipientType());
        for (User user : usersProvider.provide(notificationContext)) {
            boolean deliver = UserNotificationManagerUtil.isDeliver((long)user.getUserId(), (String)notificationContext.getPortletId(), (long)this._classNameLocalService.getClassNameId(notificationContext.getClassName()), (int)1, (int)10002);
            if (!deliver || !this._objectEntryService.hasModelResourcePermission(user, notificationContext.getClassPK(), "VIEW")) continue;
            enqueue = true;
            this.siteDefaultLocale = this.portal.getSiteDefaultLocale(user.getGroupId());
            this.userLocale = user.getLocale();
            this._userNotificationEventLocalService.sendUserNotificationEvents(user.getUserId(), notificationContext.getPortletId(), 10002, JSONUtil.put((String)"className", (Object)notificationContext.getClassName()).put("classPK", notificationContext.getClassPK()).put("externalReferenceCode", notificationContext.getExternalReferenceCode()).put("notificationMessage", this.formatLocalizedContent(notificationTemplate.getSubjectMap(), notificationContext)).put("portletId", notificationContext.getPortletId()));
            notificationRecipientSettings.add(HashMapBuilder.put((Object)"userFullName", (Object)user.getFullName()).build());
        }
        if (enqueue) {
            User user = this.userLocalService.getUser(notificationContext.getUserId());
            this.siteDefaultLocale = this.portal.getSiteDefaultLocale(user.getGroupId());
            this.userLocale = user.getLocale();
            this.prepareNotificationContext(user, null, notificationContext, notificationRecipientSettings, this.formatLocalizedContent(notificationTemplate.getSubjectMap(), notificationContext));
            this.notificationQueueEntryLocalService.addNotificationQueueEntry(notificationContext);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._usersProviders.put("role", new RoleUsersProvider(this._permissionCheckerFactory, this._roleLocalService, this._userGroupRoleLocalService, this.userLocalService));
        this._usersProviders.put("term", new TermUsersProvider(this._permissionCheckerFactory, this.notificationTermEvaluatorTracker, this.userLocalService));
        this._usersProviders.put("user", new DefaultUsersProvider(this._permissionCheckerFactory, this.userLocalService));
    }
}

