/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.notification.model.impl;

import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.service.NotificationRecipientLocalServiceUtil;

/**
 * The extended model base implementation for the NotificationRecipient service. Represents a row in the &quot;NotificationRecipient&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NotificationRecipientImpl}.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see NotificationRecipientImpl
 * @see NotificationRecipient
 * @generated
 */
public abstract class NotificationRecipientBaseImpl
	extends NotificationRecipientModelImpl implements NotificationRecipient {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a notification recipient model instance should use the <code>NotificationRecipient</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			NotificationRecipientLocalServiceUtil.addNotificationRecipient(
				this);
		}
		else {
			NotificationRecipientLocalServiceUtil.updateNotificationRecipient(
				this);
		}
	}

}