/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.impl;

import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.service.base.MDRRuleGroupServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=mdr", "json.web.service.context.path=MDRRuleGroup"}, service={AopService.class})
public class MDRRuleGroupServiceImpl
extends MDRRuleGroupServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.mobile.device.rules.model.MDRRuleGroup)")
    private ModelResourcePermission<MDRRuleGroup> _mdrRuleGroupModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.mobile.device.rules)")
    private PortletResourcePermission _portletResourcePermission;

    public MDRRuleGroup addRuleGroup(long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_RULE_GROUP");
        return this.mdrRuleGroupLocalService.addRuleGroup(groupId, nameMap, descriptionMap, serviceContext);
    }

    public MDRRuleGroup copyRuleGroup(long ruleGroupId, long groupId, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        MDRRuleGroup ruleGroup = this.getRuleGroup(ruleGroupId);
        this._mdrRuleGroupModelResourcePermission.check(permissionChecker, (ClassedModel)ruleGroup, "VIEW");
        this._portletResourcePermission.check(permissionChecker, groupId, "ADD_RULE_GROUP");
        return this.mdrRuleGroupLocalService.copyRuleGroup(ruleGroup, groupId, serviceContext);
    }

    public void deleteRuleGroup(long ruleGroupId) throws PortalException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        this._mdrRuleGroupModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ruleGroup, "DELETE");
        this.mdrRuleGroupLocalService.deleteRuleGroup(ruleGroup);
    }

    public MDRRuleGroup fetchRuleGroup(long ruleGroupId) throws PortalException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.fetchByPrimaryKey(ruleGroupId);
        if (ruleGroup != null) {
            this._mdrRuleGroupModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ruleGroup, "VIEW");
        }
        return ruleGroup;
    }

    public MDRRuleGroup getRuleGroup(long ruleGroupId) throws PortalException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        this._mdrRuleGroupModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ruleGroup, "VIEW");
        return ruleGroup;
    }

    public List<MDRRuleGroup> getRuleGroups(long[] groupIds, int start, int end) {
        return this.mdrRuleGroupPersistence.filterFindByGroupId(groupIds, start, end);
    }

    public int getRuleGroupsCount(long[] groupIds) {
        return this.mdrRuleGroupPersistence.filterCountByGroupId(groupIds);
    }

    public MDRRuleGroup updateRuleGroup(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        this._mdrRuleGroupModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ruleGroup, "UPDATE");
        return this.mdrRuleGroupLocalService.updateRuleGroup(ruleGroupId, nameMap, descriptionMap, serviceContext);
    }
}

