/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.persistence.impl;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.impl.MBThreadImpl;
import com.liferay.message.boards.service.persistence.MBThreadFinder;
import com.liferay.message.boards.service.persistence.MBThreadUtil;
import com.liferay.message.boards.service.persistence.impl.MBThreadFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MBThreadFinder.class})
public class MBThreadFinderImpl
extends MBThreadFinderBaseImpl
implements MBThreadFinder {
    public static final String COUNT_BY_G_U = MBThreadFinder.class.getName() + ".countByG_U";
    public static final String COUNT_BY_G_C = MBThreadFinder.class.getName() + ".countByG_C";
    public static final String COUNT_BY_G_U_C = MBThreadFinder.class.getName() + ".countByG_U_C";
    public static final String COUNT_BY_G_U_LPD = MBThreadFinder.class.getName() + ".countByG_U_LPD";
    public static final String COUNT_BY_G_U_A = MBThreadFinder.class.getName() + ".countByG_U_A";
    public static final String COUNT_BY_S_G_U = MBThreadFinder.class.getName() + ".countByS_G_U";
    public static final String COUNT_BY_G_U_C_A = MBThreadFinder.class.getName() + ".countByG_U_C_A";
    public static final String COUNT_BY_S_G_U_C = MBThreadFinder.class.getName() + ".countByS_G_U_C";
    public static final String FIND_BY_G_U = MBThreadFinder.class.getName() + ".findByG_U";
    public static final String FIND_BY_G_C = MBThreadFinder.class.getName() + ".findByG_C";
    public static final String FIND_BY_G_U_C = MBThreadFinder.class.getName() + ".findByG_U_C";
    public static final String FIND_BY_G_U_LPD = MBThreadFinder.class.getName() + ".findByG_U_LPD";
    public static final String FIND_BY_G_U_A = MBThreadFinder.class.getName() + ".findByG_U_A";
    public static final String FIND_BY_S_G_U = MBThreadFinder.class.getName() + ".findByS_G_U";
    public static final String FIND_BY_G_U_C_A = MBThreadFinder.class.getName() + ".findByG_U_C_A";
    public static final String FIND_BY_S_G_U_C = MBThreadFinder.class.getName() + ".findByS_G_U_C";
    private static final String _INNER_JOIN_SQL = "INNER JOIN MBMessage ON MBThread.threadId = MBMessage.threadId";
    private static final String _USER_ID_SQL = "AND (MBMessage.userId = ?)";
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private Portal _portal;

    public int countByG_U(long groupId, long userId, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U);
            sql = this.updateSQL(sql, queryDefinition);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(userId);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_C(long groupId, long categoryId, QueryDefinition<MBThread> queryDefinition) {
        return this.doCountByG_C(groupId, categoryId, queryDefinition, false);
    }

    public int countByG_U_C(long groupId, long userId, long[] categoryIds, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U_C);
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(MBThread.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR MBThread.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"MBThread.categoryId = ?", (String)("MBThread.categoryId = " + mergedCategoryIds));
            }
            sql = this.updateSQL(sql, queryDefinition);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(userId);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_U_LPD(long groupId, long userId, Date lastPostDate, QueryDefinition<MBThread> queryDefinition) {
        return this.countByG_U_LPD_A(groupId, userId, lastPostDate, true, queryDefinition);
    }

    public int countByG_U_A(long groupId, long userId, boolean anonymous, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U_A);
            sql = this.updateSQL(sql, queryDefinition);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(userId);
            queryPos.add(anonymous);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByS_G_U(long groupId, long userId, QueryDefinition<MBThread> queryDefinition) {
        return this.doCountByS_G_U(groupId, userId, queryDefinition);
    }

    public int countByG_U_C_A(long groupId, long userId, long[] categoryIds, boolean anonymous, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U_C);
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(MBThread.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR MBThread.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"MBThread.categoryId = ?", (String)("MBThread.categoryId = " + mergedCategoryIds));
            }
            sql = this.updateSQL(sql, queryDefinition);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(userId);
            queryPos.add(anonymous);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_U_LPD_A(long groupId, long userId, Date lastPostDate, boolean includeAnonymous, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U_LPD);
            if (userId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)"DISTINCT MBThread.threadId", (String)"*");
                sql = StringUtil.removeSubstring((String)sql, (String)_INNER_JOIN_SQL);
                sql = StringUtil.removeSubstring((String)sql, (String)_USER_ID_SQL);
            }
            sql = this.updateSQL(sql, queryDefinition);
            if (!includeAnonymous && userId > 0L) {
                sql = this._customSQL.appendCriteria(sql, "AND (MBMessage.anonymous = [$FALSE$])");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(lastPostDate);
            if (userId > 0L) {
                queryPos.add(userId);
            }
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByS_G_U_C(long groupId, long userId, long[] categoryIds, QueryDefinition<MBThread> queryDefinition) {
        return this.doCountByS_G_U_C(groupId, userId, categoryIds, queryDefinition, false);
    }

    public int filterCountByG_C(long groupId, long categoryId) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return MBThreadUtil.countByG_C((long)groupId, (long)categoryId);
        }
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            QueryDefinition queryDefinition = new QueryDefinition(-1);
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_C, queryDefinition, "MBThread");
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"MBThread.rootMessageId", (long)groupId);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(categoryId);
            queryPos.add(-1);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int filterCountByG_C(long groupId, long categoryId, QueryDefinition<MBThread> queryDefinition) {
        return this.doCountByG_C(groupId, categoryId, queryDefinition, true);
    }

    public int filterCountByS_G_U_C(long groupId, long userId, long[] categoryIds, QueryDefinition<MBThread> queryDefinition) {
        return this.doCountByS_G_U_C(groupId, userId, categoryIds, queryDefinition, true);
    }

    public List<MBThread> filterFindByG_C(long groupId, long categoryId, int start, int end) {
        if (!InlineSQLHelperUtil.isEnabled((long)groupId)) {
            return MBThreadUtil.findByG_C((long)groupId, (long)categoryId, (int)start, (int)end);
        }
        Session session = null;
        try {
            session = this.openSession();
            QueryDefinition queryDefinition = new QueryDefinition(-1);
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_C, queryDefinition, "MBThread");
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"MBThread.rootMessageId", (long)groupId);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBThread", MBThreadImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(categoryId);
            queryPos.add(-1);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MBThread> filterFindByG_C(long groupId, long categoryId, QueryDefinition<MBThread> queryDefinition) {
        return this.doFindByG_C(groupId, categoryId, queryDefinition, true);
    }

    public List<MBThread> filterFindByS_G_U_C(long groupId, long userId, long[] categoryIds, QueryDefinition<MBThread> queryDefinition) {
        return this.doFindByS_G_U_C(groupId, userId, categoryIds, queryDefinition, true);
    }

    public List<MBThread> findByG_U(long groupId, long userId, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U);
            sql = this.updateSQL(sql, queryDefinition);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBThread", MBThreadImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(userId);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MBThread> findByG_C(long groupId, long categoryId, QueryDefinition<MBThread> queryDefinition) {
        return this.doFindByG_C(groupId, categoryId, queryDefinition, false);
    }

    public List<MBThread> findByG_U_C(long groupId, long userId, long[] categoryIds, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_C);
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(MBThread.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR MBThread.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"MBThread.categoryId = ?", (String)("MBThread.categoryId = " + mergedCategoryIds));
            }
            sql = this.updateSQL(sql, queryDefinition);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBThread", MBThreadImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(userId);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MBThread> findByG_U_LPD(long groupId, long userId, Date lastPostDate, QueryDefinition<MBThread> queryDefinition) {
        return this.findByG_U_LPD_A(groupId, userId, lastPostDate, true, queryDefinition);
    }

    public List<MBThread> findByG_U_A(long groupId, long userId, boolean anonymous, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_A);
            sql = this.updateSQL(sql, queryDefinition);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBThread", MBThreadImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(userId);
            queryPos.add(anonymous);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MBThread> findByS_G_U(long groupId, long userId, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_S_G_U);
            sql = this.updateSQL(sql, queryDefinition);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBThread", MBThreadImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(this._portal.getClassNameId(MBThread.class.getName()));
            queryPos.add(groupId);
            queryPos.add(userId);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MBThread> findByG_U_C_A(long groupId, long userId, long[] categoryIds, boolean anonymous, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_C_A);
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(MBThread.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR MBThread.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"MBThread.categoryId = ?", (String)("MBThread.categoryId = " + mergedCategoryIds));
            }
            sql = this.updateSQL(sql, queryDefinition);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBThread", MBThreadImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(userId);
            queryPos.add(anonymous);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MBThread> findByG_U_LPD_A(long groupId, long userId, Date lastPostDate, boolean includeAnonymous, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_LPD);
            if (userId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"DISTINCT ");
                sql = StringUtil.removeSubstring((String)sql, (String)_INNER_JOIN_SQL);
                sql = StringUtil.removeSubstring((String)sql, (String)_USER_ID_SQL);
            }
            sql = this.updateSQL(sql, queryDefinition);
            if (!includeAnonymous && userId > 0L) {
                sql = this._customSQL.appendCriteria(sql, "AND (MBMessage.anonymous = [$FALSE$])");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBThread", MBThreadImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(lastPostDate);
            if (userId > 0L) {
                queryPos.add(userId);
            }
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MBThread> findByS_G_U_C(long groupId, long userId, long[] categoryIds, QueryDefinition<MBThread> queryDefinition) {
        return this.doFindByS_G_U_C(groupId, userId, categoryIds, queryDefinition, false);
    }

    protected int doCountByG_C(long groupId, long categoryId, QueryDefinition<MBThread> queryDefinition, boolean inlineSQLHelper) {
        if (!inlineSQLHelper || !InlineSQLHelperUtil.isEnabled((long)groupId)) {
            if (queryDefinition.isExcludeStatus()) {
                return MBThreadUtil.countByG_C_NotS((long)groupId, (long)categoryId, (int)queryDefinition.getStatus());
            }
            if (queryDefinition.getStatus() != -1) {
                return MBThreadUtil.countByG_C_S((long)groupId, (long)categoryId, (int)queryDefinition.getStatus());
            }
            return MBThreadUtil.countByG_C((long)groupId, (long)categoryId);
        }
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_C, queryDefinition, "MBThread");
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"MBThread.rootMessageId", (long)groupId);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(categoryId);
            queryPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByS_G_U(long groupId, long userId, QueryDefinition<MBThread> queryDefinition) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_S_G_U);
            sql = this.updateSQL(sql, queryDefinition);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(this._portal.getClassNameId(MBThread.class.getName()));
            queryPos.add(groupId);
            queryPos.add(userId);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByS_G_U_C(long groupId, long userId, long[] categoryIds, QueryDefinition<MBThread> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_S_G_U_C);
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(MBThread.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR MBThread.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"MBThread.categoryId = ?", (String)("MBThread.categoryId = " + mergedCategoryIds));
            }
            sql = this.updateSQL(sql, queryDefinition);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"MBThread.rootMessageId", (long)groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(this._portal.getClassNameId(MBThread.class.getName()));
            queryPos.add(groupId);
            queryPos.add(userId);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<MBThread> doFindByG_C(long groupId, long categoryId, QueryDefinition<MBThread> queryDefinition, boolean inlineSQLHelper) {
        if (!inlineSQLHelper || !InlineSQLHelperUtil.isEnabled((long)groupId)) {
            if (queryDefinition.isExcludeStatus()) {
                return MBThreadUtil.findByG_C_NotS((long)groupId, (long)categoryId, (int)queryDefinition.getStatus(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd(), (OrderByComparator)queryDefinition.getOrderByComparator());
            }
            if (queryDefinition.getStatus() != -1) {
                return MBThreadUtil.findByG_C_S((long)groupId, (long)categoryId, (int)queryDefinition.getStatus(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd(), (OrderByComparator)queryDefinition.getOrderByComparator());
            }
            return MBThreadUtil.findByG_C((long)groupId, (long)categoryId, (int)queryDefinition.getStart(), (int)queryDefinition.getEnd(), (OrderByComparator)queryDefinition.getOrderByComparator());
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_C, queryDefinition, "MBThread");
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"MBThread.rootMessageId", (long)groupId);
            sql = this._customSQL.replaceOrderBy(sql, queryDefinition.getOrderByComparator());
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBThread", MBThreadImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(categoryId);
            queryPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<MBThread> doFindByS_G_U_C(long groupId, long userId, long[] categoryIds, QueryDefinition<MBThread> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_S_G_U_C);
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(MBThread.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR MBThread.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"MBThread.categoryId = ?", (String)("MBThread.categoryId = " + mergedCategoryIds));
            }
            sql = this.updateSQL(sql, queryDefinition);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"MBThread.rootMessageId", (long)groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBThread", MBThreadImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(this._portal.getClassNameId(MBThread.class.getName()));
            queryPos.add(groupId);
            queryPos.add(userId);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String updateSQL(String sql, QueryDefinition<MBThread> queryDefinition) {
        if (queryDefinition.getStatus() == -1) {
            return sql;
        }
        if (queryDefinition.isExcludeStatus()) {
            return this._customSQL.appendCriteria(sql, "AND (MBThread.status != ?)");
        }
        return this._customSQL.appendCriteria(sql, "AND (MBThread.status = ?)");
    }
}

