/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.util;

import com.liferay.mail.kernel.service.MailService;
import com.liferay.message.boards.internal.util.MBMailMessage;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Part;
import jakarta.mail.internet.MimeMultipart;
import java.io.InputStream;
import java.util.Map;

public class MBMailUtil {
    public static final String MESSAGE_POP_PORTLET_PREFIX = "mb_message.";
    private static final Log _log = LogFactoryUtil.getLog(MBMailUtil.class);

    public static void collectPartContent(Part part, MBMailMessage mbMailMessage) throws Exception {
        Object partContent = MBMailUtil._getPartContent(part);
        if (part.getDisposition() != null && StringUtil.equalsIgnoreCase((String)part.getDisposition(), (String)"attachment")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing attachment");
            }
            byte[] bytes = null;
            if (partContent instanceof String) {
                String s = (String)partContent;
                bytes = s.getBytes();
            } else if (partContent instanceof InputStream) {
                bytes = StreamUtil.toByteArray((InputStream)part.getInputStream());
            }
            mbMailMessage.addBytes(part.getFileName(), bytes);
        } else if (partContent instanceof MimeMultipart) {
            MimeMultipart mimeMultipart = (MimeMultipart)partContent;
            for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                BodyPart curPart = mimeMultipart.getBodyPart(i);
                MBMailUtil.collectPartContent((Part)curPart, mbMailMessage);
            }
        } else if (partContent instanceof String) {
            String contentType = StringUtil.toLowerCase((String)part.getContentType());
            String messageBody = SanitizerUtil.sanitize((long)0L, (long)0L, (long)0L, (String)MBMessage.class.getName(), (long)0L, (String)contentType, (String)"ALL", (String)((String)partContent), (Map)HashMapBuilder.put((Object)"emailPartToMBMessageBody", (Object)Boolean.TRUE).build());
            if (contentType.startsWith("text/html")) {
                mbMailMessage.setHtmlBody(messageBody);
            } else {
                mbMailMessage.setPlainBody(messageBody);
            }
        }
    }

    public static long getCategoryId(String messageIdString) {
        String[] parts = MBMailUtil._getMessageIdStringParts(messageIdString);
        return GetterUtil.getLong((String)parts[0]);
    }

    public static long getMessageId(String messageIdString) {
        String[] parts = MBMailUtil._getMessageIdStringParts(messageIdString);
        return GetterUtil.getLong((String)parts[1]);
    }

    public static long getParentMessageId(Message message) throws Exception {
        long parentMessageId = -1L;
        String parentMessageIdString = MBMailUtil.getParentMessageIdString(message);
        if (parentMessageIdString != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parent header " + parentMessageIdString));
            }
            parentMessageId = MBMailUtil.getMessageId(parentMessageIdString);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parent message id " + parentMessageId));
            }
        }
        return parentMessageId;
    }

    public static String getParentMessageIdString(Message message) throws Exception {
        Object[] inReplyToHeaders;
        Object reference;
        int x;
        Object parentHeader = null;
        Object[] references = message.getHeader("References");
        if (ArrayUtil.isNotEmpty((Object[])references) && (x = ((String)(reference = references[0])).lastIndexOf("<mb_message.")) > -1) {
            int y = ((String)reference).indexOf(">", x);
            parentHeader = ((String)reference).substring(x, y + 1);
        }
        if (parentHeader == null && ArrayUtil.isNotEmpty((Object[])(inReplyToHeaders = message.getHeader("In-Reply-To")))) {
            parentHeader = inReplyToHeaders[0];
        }
        if (Validator.isNull(parentHeader) || !((String)parentHeader).startsWith(MESSAGE_POP_PORTLET_PREFIX, 1)) {
            parentHeader = MBMailUtil._getParentMessageIdFromSubject(message);
        }
        return parentHeader;
    }

    public static String getReplyToAddress(MailService mailService, long categoryId, long messageId, String mx, String defaultMailingListAddress) {
        if (!MBMailUtil.hasSubdomain(mailService)) {
            return defaultMailingListAddress;
        }
        return StringBundler.concat((Object[])new Object[]{MESSAGE_POP_PORTLET_PREFIX, categoryId, ".", messageId, "@", mailService.getPOPServerSubdomain(), ".", mx});
    }

    public static String getSubjectForEmail(MBMessage message) throws Exception {
        String subject = message.getSubject();
        if (subject.startsWith("RE: ")) {
            return subject;
        }
        return "RE: " + message.getSubject();
    }

    public static String getSubjectWithoutMessageId(Message message) throws Exception {
        int pos;
        String subject = message.getSubject();
        String parentMessageId = MBMailUtil._getParentMessageIdFromSubject(message);
        if (Validator.isNotNull((String)parentMessageId) && (pos = subject.indexOf(parentMessageId)) != -1) {
            subject = subject.substring(0, pos);
        }
        return subject;
    }

    public static boolean hasMailIdHeader(MailService mailService, Message message) throws Exception {
        String[] messageIds = message.getHeader("Message-ID");
        if (messageIds == null || !MBMailUtil.hasSubdomain(mailService)) {
            return false;
        }
        for (String messageId : messageIds) {
            if (!messageId.contains(mailService.getPOPServerSubdomain())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSubdomain(MailService mailService) {
        return Validator.isNotNull((String)mailService.getPOPServerSubdomain());
    }

    private static String[] _getMessageIdStringParts(String messageIdString) {
        int start = messageIdString.indexOf(MESSAGE_POP_PORTLET_PREFIX) + MESSAGE_POP_PORTLET_PREFIX.length();
        int end = messageIdString.indexOf(64);
        return StringUtil.split((String)messageIdString.substring(start, end), (char)'.');
    }

    private static String _getParentMessageIdFromSubject(Message message) throws Exception {
        if (message.getSubject() == null) {
            return null;
        }
        String parentMessageId = null;
        String subject = message.getSubject();
        int pos = subject.lastIndexOf(60);
        if (pos != -1) {
            parentMessageId = subject.substring(pos);
        }
        return parentMessageId;
    }

    private static Object _getPartContent(Part part) throws Exception {
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)Part.class.getClassLoader());){
            Object object = part.getContent();
            return object;
        }
    }
}

