/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.helper;

import com.liferay.message.boards.internal.util.MBUtil;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MBMessageNotificationTemplateHelper {
    private static final String _QUOTE_MARK = ">";
    private static final Log _log = LogFactoryUtil.getLog(MBMessageNotificationTemplateHelper.class);
    private final boolean _htmlFormat;
    private final Map<MarkupElement, String> _markupElements = HashMapBuilder.put((Object)((Object)MarkupElement.END), (Object)"</div>").put((Object)MarkupElement.END_ELEMENT, (Object)"</ul>").put((Object)MarkupElement.END_MESSAGE, (Object)"</li>").put((Object)MarkupElement.START_BODY_ROOT, (Object)"<div class=\"mb-root-message-body\">").put((Object)MarkupElement.START_BODY_SIBLING, (Object)"<div class=\"mb-sibling-message-body\">").put((Object)MarkupElement.START_MESSAGE, (Object)"<ul><li class=\"mb-parent-message\">").put((Object)MarkupElement.START_MESSAGE_BODY, (Object)"<div class=\"mb-parent-message-body\">").put((Object)MarkupElement.START_MESSAGE_SIBLING, (Object)"<div class=\"mb-sibling-message\">").put((Object)MarkupElement.START_MESSAGE_THREAD, (Object)"<div class=\"mb-parent-message-thread\">").put((Object)MarkupElement.START_ROOT, (Object)"<div class=\"mb-root-message\">").put((Object)MarkupElement.START_SIBLING, (Object)"<div class=\"mb-sibling-message-thread\">").put((Object)MarkupElement.START_USER_MESSAGE, (Object)"<div class=\"mb-parent-message-user\">").put((Object)MarkupElement.START_USER_ROOT, (Object)"<div class=\"mb-root-message-user\">").put((Object)MarkupElement.START_USER_SIBLING, (Object)"<div class=\"mb-sibling-message-user\">").build();
    private final int _maxNumberOfMessages;
    private final int _maxNumberOfParentMessages;
    private final MBMessageLocalService _mbMessageLocalService;
    private final Map<Long, Integer> _numberOfMessagesByParentMessageIds = new HashMap<Long, Integer>();
    private final ServiceContext _serviceContext;

    public MBMessageNotificationTemplateHelper(boolean htmlFormat, int maxNumberOfMessages, int maxNumberOfParentMessages, MBMessageLocalService mbMessageLocalService, ServiceContext serviceContext) {
        this._htmlFormat = htmlFormat;
        this._maxNumberOfMessages = maxNumberOfMessages;
        this._maxNumberOfParentMessages = maxNumberOfParentMessages;
        this._mbMessageLocalService = mbMessageLocalService;
        this._serviceContext = serviceContext;
    }

    public String getMessageBody(MBMessage message, String quoteMark) {
        if (!this._htmlFormat) {
            return this._getQuotedMessage(true, message.getBody(), quoteMark);
        }
        if (!message.isFormatBBCode()) {
            return message.getBody();
        }
        try {
            String messageBody = BBCodeTranslatorUtil.getHTML((String)message.getBody());
            HttpServletRequest httpServletRequest = this._serviceContext.getRequest();
            if (httpServletRequest == null) {
                return messageBody;
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            return MBUtil.replaceMessageBodyPaths(themeDisplay, messageBody);
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to parse message ", message.getMessageId(), ": ", exception.getMessage()}));
            return message.getBody();
        }
    }

    public String renderMessageParentMessageContent(MBMessage parentMessage) {
        if (this._maxNumberOfParentMessages == 0 || parentMessage.getParentMessageId() == 0L) {
            return "";
        }
        LinkedList<MBMessage> messages = new LinkedList<MBMessage>();
        for (int numberOfMessages = this._maxNumberOfParentMessages; numberOfMessages > 0 && parentMessage != null && parentMessage.getParentMessageId() != 0L; --numberOfMessages) {
            messages.add(0, parentMessage);
            parentMessage = this._mbMessageLocalService.fetchMBMessage(parentMessage.getParentMessageId());
        }
        this._numberOfMessagesByParentMessageIds.put(parentMessage.getMessageId(), messages.size());
        if (ListUtil.isEmpty(messages)) {
            return "";
        }
        StringBundler sb = new StringBundler(messages.size());
        sb.append(this._getMarkupElement(MarkupElement.START_MESSAGE_THREAD));
        int elementCount = 0;
        for (MBMessage message : messages) {
            sb.append(StringBundler.concat((String[])new String[]{this._getMarkupElement(MarkupElement.START_MESSAGE), this._getMarkupElement(MarkupElement.START_USER_MESSAGE), this._getUserName(message, this._getQuote(elementCount)), this._getMarkupElement(MarkupElement.END), this._getMarkupElement(MarkupElement.START_MESSAGE_BODY), this.getMessageBody(message, this._getQuote(elementCount)), this._getMarkupElement(MarkupElement.END), this._getMarkupElement(MarkupElement.END_MESSAGE)}));
            ++elementCount;
        }
        for (int i = 0; i < elementCount; ++i) {
            sb.append(this._getMarkupElement(MarkupElement.END_ELEMENT));
        }
        sb.append(this._getMarkupElement(MarkupElement.END));
        return sb.toString();
    }

    public String renderMessageSiblingMessagesContent(MBMessage message) {
        int numberOfMessagesByParentMessageId = this._numberOfMessagesByParentMessageIds.getOrDefault(message.getParentMessageId(), 0);
        int numberOfMessages = this._maxNumberOfMessages - numberOfMessagesByParentMessageId;
        if (numberOfMessages == 0) {
            return "";
        }
        int childMessagesCount = this._mbMessageLocalService.getChildMessagesCount(message.getParentMessageId(), 0);
        if (childMessagesCount == 1) {
            return "";
        }
        List childMessages = this._mbMessageLocalService.getChildMessages(message.getParentMessageId(), 0, childMessagesCount - numberOfMessages - 1, childMessagesCount - 1);
        if (ListUtil.isEmpty((List)childMessages)) {
            return "";
        }
        String quoteMark = this._getQuote(numberOfMessagesByParentMessageId + 1);
        StringBundler sb = new StringBundler(childMessages.size() + 2);
        sb.append(this._getMarkupElement(MarkupElement.START_SIBLING));
        for (MBMessage childMessage : childMessages) {
            sb.append(StringBundler.concat((String[])new String[]{this._getMarkupElement(MarkupElement.START_MESSAGE_SIBLING), this._getMarkupElement(MarkupElement.START_USER_SIBLING), this._getUserName(childMessage, quoteMark), this._getMarkupElement(MarkupElement.END), this._getMarkupElement(MarkupElement.START_BODY_SIBLING), this.getMessageBody(childMessage, quoteMark), this._getMarkupElement(MarkupElement.END), this._getMarkupElement(MarkupElement.END)}));
        }
        sb.append(this._getMarkupElement(MarkupElement.END));
        return sb.toString();
    }

    public String renderRootMessage(MBMessage message) throws PortalException {
        if (message.getParentMessageId() == 0L) {
            return "";
        }
        MBMessage rootMessage = this._mbMessageLocalService.getMessage(message.getRootMessageId());
        return StringBundler.concat((String[])new String[]{this._getMarkupElement(MarkupElement.START_ROOT), this._getMarkupElement(MarkupElement.START_USER_ROOT), this._getUserName(rootMessage, this._getQuoteMark()), this._getMarkupElement(MarkupElement.END), this._getMarkupElement(MarkupElement.START_BODY_ROOT), this.getMessageBody(rootMessage, this._getQuoteMark()), this._getMarkupElement(MarkupElement.END), this._getMarkupElement(MarkupElement.END)});
    }

    private String _getMarkupElement(MarkupElement element) {
        if (!this._htmlFormat) {
            return "";
        }
        return this._markupElements.getOrDefault((Object)element, "");
    }

    private String _getQuote(int depth) {
        if (Validator.isBlank((String)this._getQuoteMark())) {
            return "";
        }
        return StringUtils.repeat((String)_QUOTE_MARK, (int)depth) + this._getQuoteMark();
    }

    private String _getQuotedMessage(boolean lastPosition, String messageBody, String quoteMark) {
        if (Validator.isBlank((String)quoteMark)) {
            return messageBody;
        }
        StringBundler sb = new StringBundler();
        for (String line : messageBody.split("\n")) {
            sb.append("\n");
            sb.append(quoteMark);
            sb.append(line);
        }
        sb.append("\n");
        if (!lastPosition) {
            sb.append(quoteMark);
        }
        return sb.toString();
    }

    private String _getQuoteMark() {
        if (this._htmlFormat) {
            return "";
        }
        return "> ";
    }

    private String _getUserName(MBMessage message, String quoteMark) {
        if (!this._htmlFormat) {
            return this._getQuotedMessage(false, message.getUserName(), quoteMark);
        }
        return message.getUserName() + "<br />";
    }

    private static enum MarkupElement {
        END,
        END_ELEMENT,
        END_MESSAGE,
        START_BODY_ROOT,
        START_BODY_SIBLING,
        START_MESSAGE,
        START_MESSAGE_BODY,
        START_MESSAGE_SIBLING,
        START_MESSAGE_THREAD,
        START_ROOT,
        START_SIBLING,
        START_USER_MESSAGE,
        START_USER_ROOT,
        START_USER_SIBLING;

    }
}

