/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.exception.LockedThreadException;
import com.liferay.message.boards.internal.util.MBUtil;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.message.boards.service.base.MBMessageServiceBaseImpl;
import com.liferay.message.boards.util.comparator.MessageCreateDateComparator;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.rss.export.RSSExporter;
import com.liferay.rss.model.SyndContent;
import com.liferay.rss.model.SyndEntry;
import com.liferay.rss.model.SyndFeed;
import com.liferay.rss.model.SyndLink;
import com.liferay.rss.model.SyndModelFactory;
import com.liferay.rss.util.RSSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=mb", "json.web.service.context.path=MBMessage"}, service={AopService.class})
public class MBMessageServiceImpl
extends MBMessageServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBCategory)")
    private ModelResourcePermission<MBCategory> _categoryModelResourcePermission;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DiscussionPermission _discussionPermission;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private Language _language;
    @Reference
    private LockManager _lockManager;
    @Reference
    private MBCategoryLocalService _mbCategoryLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBMessage)")
    private ModelResourcePermission<MBMessage> _messageModelResourcePermission;
    @Reference
    private Portal _portal;
    @Reference
    private RSSExporter _rssExporter;
    @Reference
    private SyndModelFactory _syndModelFactory;

    public MBMessage addDiscussionMessage(long groupId, String className, long classPK, long threadId, long parentMessageId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        User user = this.getGuestOrUser();
        this._discussionPermission.checkAddPermission(this.getPermissionChecker(), user.getCompanyId(), serviceContext.getScopeGroupId(), className, classPK);
        return this.mbMessageLocalService.addDiscussionMessage(null, user.getUserId(), null, groupId, className, classPK, threadId, parentMessageId, subject, body, serviceContext);
    }

    @Deprecated
    public MBMessage addMessage(long groupId, long categoryId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)categoryId, (String)"ADD_MESSAGE");
        if (!ModelResourcePermissionUtil.contains(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)categoryId, (String)"ADD_FILE")) {
            inputStreamOVPs = Collections.emptyList();
        }
        if (!ModelResourcePermissionUtil.contains(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)categoryId, (String)"UPDATE_THREAD_PRIORITY")) {
            priority = -1.0;
        }
        return this.mbMessageLocalService.addMessage(this.getGuestOrUserId(), null, groupId, categoryId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    @Deprecated
    public MBMessage addMessage(long groupId, long categoryId, String subject, String body, String format, String fileName, File file, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws FileNotFoundException, PortalException {
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>();
        FileInputStream inputStream = new FileInputStream(file);
        ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
        inputStreamOVPs.add(inputStreamOVP);
        return this.addMessage(groupId, categoryId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    @Deprecated
    public MBMessage addMessage(long categoryId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(categoryId);
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = Collections.emptyList();
        return this.addMessage(category.getGroupId(), categoryId, subject, body, MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, false, 0.0, false, serviceContext);
    }

    @Deprecated
    public MBMessage addMessage(long parentMessageId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        return this.addMessage(null, parentMessageId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public MBMessage addMessage(String externalReferenceCode, long parentMessageId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage parentMessage = this.mbMessagePersistence.findByPrimaryKey(parentMessageId);
        this._checkReplyToPermission(parentMessage.getGroupId(), parentMessage.getCategoryId(), parentMessageId);
        boolean preview = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"preview");
        int workflowAction = serviceContext.getWorkflowAction();
        if (workflowAction == 2 && !preview && !serviceContext.isSignedIn()) {
            this._messageModelResourcePermission.check(this.getPermissionChecker(), parentMessageId, "UPDATE");
        }
        if (this._lockManager.isLocked(MBThread.class.getName(), parentMessage.getThreadId())) {
            throw new LockedThreadException(StringBundler.concat((Object[])new Object[]{"Thread is locked for class name ", MBThread.class.getName(), " and class PK ", parentMessage.getThreadId()}));
        }
        if (!ModelResourcePermissionUtil.contains(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)parentMessage.getGroupId(), (long)parentMessage.getCategoryId(), (String)"ADD_FILE")) {
            inputStreamOVPs = Collections.emptyList();
        }
        if (!ModelResourcePermissionUtil.contains(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)parentMessage.getGroupId(), (long)parentMessage.getCategoryId(), (String)"UPDATE_THREAD_PRIORITY")) {
            priority = -1.0;
        }
        return this.mbMessageLocalService.addMessage(externalReferenceCode, this.getGuestOrUserId(), null, parentMessage.getGroupId(), parentMessage.getCategoryId(), parentMessage.getThreadId(), parentMessageId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public void addMessageAttachment(long messageId, String fileName, File file, String mimeType) throws PortalException {
        MBMessage message = this.mbMessageLocalService.getMBMessage(messageId);
        if (this._lockManager.isLocked(MBThread.class.getName(), message.getThreadId())) {
            throw new LockedThreadException(StringBundler.concat((Object[])new Object[]{"Thread is locked for class name ", MBThread.class.getName(), " and class PK ", message.getThreadId()}));
        }
        ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)message.getGroupId(), (long)message.getCategoryId(), (String)"ADD_FILE");
        this.mbMessageLocalService.addMessageAttachment(this.getUserId(), messageId, fileName, file, mimeType);
    }

    public FileEntry addTempAttachment(long groupId, long categoryId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)categoryId, (String)"ADD_FILE");
        return this.mbMessageLocalService.addTempAttachment(groupId, this.getUserId(), folderName, fileName, inputStream, mimeType);
    }

    public void deleteDiscussionMessage(long messageId) throws PortalException {
        this._discussionPermission.checkDeletePermission(this.getPermissionChecker(), messageId);
        this.mbMessageLocalService.deleteDiscussionMessage(messageId);
    }

    public void deleteMessage(long messageId) throws PortalException {
        this._messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "DELETE");
        this.mbMessageLocalService.deleteMessage(messageId);
    }

    public void deleteMessageAttachment(long messageId, String fileName) throws PortalException {
        this._messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "UPDATE");
        this.mbMessageLocalService.deleteMessageAttachment(messageId, fileName);
    }

    public void deleteMessageAttachments(long messageId) throws PortalException {
        this._messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "DELETE");
        this.mbMessageLocalService.deleteMessageAttachments(messageId);
    }

    public void deleteTempAttachment(long groupId, long categoryId, String folderName, String fileName) throws PortalException {
        ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)categoryId, (String)"ADD_FILE");
        this.mbMessageLocalService.deleteTempAttachment(groupId, this.getUserId(), folderName, fileName);
    }

    public void emptyMessageAttachments(long messageId) throws PortalException {
        this._messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "DELETE");
        this.mbMessageLocalService.emptyMessageAttachments(messageId);
    }

    public MBMessage fetchMBMessageByUrlSubject(long groupId, String urlSubject) throws PortalException {
        MBMessage mbMessage = this.mbMessageLocalService.fetchMBMessageByUrlSubject(groupId, urlSubject);
        if (mbMessage == null) {
            return null;
        }
        this._messageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)mbMessage, "VIEW");
        return mbMessage;
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end) throws PortalException {
        return TransformUtil.transform((Collection)this.mbMessageLocalService.getCategoryMessages(groupId, categoryId, status, start, end), message -> {
            if (this._messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) {
                return message;
            }
            return null;
        });
    }

    public int getCategoryMessagesCount(long groupId, long categoryId, int status) {
        return this.mbMessageLocalService.getCategoryMessagesCount(groupId, categoryId, status);
    }

    public String getCategoryMessagesRSS(long groupId, long categoryId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        String name = "";
        String description = "";
        MBCategory category = this._mbCategoryLocalService.fetchMBCategory(categoryId);
        if (category == null) {
            Group group = this._groupLocalService.getGroup(categoryId);
            groupId = group.getGroupId();
            categoryId = 0L;
            name = group.getDescriptiveName();
            description = group.getDescription(LocaleUtil.getMostRelevantLocale());
        } else {
            groupId = category.getGroupId();
            name = category.getName();
            description = category.getDescription();
        }
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = MessageCreateDateComparator.getInstance((boolean)false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getCategoryMessages(groupId, categoryId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!this._messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this._exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public List<MBMessage> getChildMessages(long parentMessageId, boolean flatten, QueryDefinition<MBMessage> queryDefinition) throws PortalException {
        if (queryDefinition.isIncludeOwner() && queryDefinition.getOwnerUserId() != 0L) {
            queryDefinition.setOwnerUserId(this.getUserId());
        }
        return this.mbMessageFinder.findByParentMessageId(parentMessageId, flatten, queryDefinition);
    }

    public int getChildMessagesCount(long parentMessageId, boolean flatten, QueryDefinition<MBMessage> queryDefinition) throws PortalException {
        if (queryDefinition.isIncludeOwner() && queryDefinition.getOwnerUserId() != 0L) {
            queryDefinition.setOwnerUserId(this.getUserId());
        }
        return this.mbMessageFinder.countByParentMessageId(parentMessageId, flatten, queryDefinition);
    }

    public String getCompanyMessagesRSS(long companyId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        Company company = this._companyLocalService.getCompany(companyId);
        String name = company.getName();
        String description = company.getName();
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = MessageCreateDateComparator.getInstance((boolean)false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getCompanyMessages(companyId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!this._messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this._exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public int getGroupMessagesCount(long groupId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.filterCountByGroupId(groupId);
        }
        return this.mbMessagePersistence.filterCountByG_S(groupId, status);
    }

    public String getGroupMessagesRSS(long groupId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        String name = group.getDescriptiveName();
        String description = group.getDescription(LocaleUtil.getMostRelevantLocale());
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = MessageCreateDateComparator.getInstance((boolean)false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getGroupMessages(groupId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!this._messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this._exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public String getGroupMessagesRSS(long groupId, long userId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        String name = group.getDescriptiveName();
        String description = group.getDescription(LocaleUtil.getMostRelevantLocale());
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = MessageCreateDateComparator.getInstance((boolean)false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getGroupMessages(groupId, userId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!this._messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this._exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public List<MBMessage> getGroupUserMessageBoardMessagesActivity(long groupId, long userId, int start, int end) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        return this.mbMessageLocalService.getGroupUserMessageBoardMessagesActivity(groupId, userId, start, end);
    }

    public int getGroupUserMessageBoardMessagesActivityCount(long groupId, long userId) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        return this.mbMessageLocalService.getGroupUserMessageBoardMessagesActivityCount(groupId, userId);
    }

    public MBMessage getMBMessageByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        MBMessage mbMessage = this.mbMessageLocalService.getMBMessageByExternalReferenceCode(externalReferenceCode, groupId);
        this._messageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)mbMessage, "VIEW");
        return mbMessage;
    }

    public MBMessage getMessage(long messageId) throws PortalException {
        this._messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "VIEW");
        return this.mbMessageLocalService.getMessage(messageId);
    }

    public MBMessageDisplay getMessageDisplay(long messageId, int status) throws PortalException {
        this._messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "VIEW");
        return this.mbMessageLocalService.getMessageDisplay(this.getGuestOrUserId(), messageId, status);
    }

    public String[] getTempAttachmentNames(long groupId, String folderName) throws PortalException {
        return this.mbMessageLocalService.getTempAttachmentNames(groupId, this.getUserId(), folderName);
    }

    public int getThreadAnswersCount(long groupId, long categoryId, long threadId) {
        return this.mbMessagePersistence.filterCountByG_C_T_A(groupId, categoryId, threadId, true);
    }

    public List<MBMessage> getThreadMessages(long groupId, long categoryId, long threadId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.filterFindByG_C_T(groupId, categoryId, threadId, start, end);
        }
        return this.mbMessagePersistence.filterFindByG_C_T_S(groupId, categoryId, threadId, status, start, end);
    }

    public int getThreadMessagesCount(long groupId, long categoryId, long threadId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.filterCountByG_C_T(groupId, categoryId, threadId);
        }
        return this.mbMessagePersistence.filterCountByG_C_T_S(groupId, categoryId, threadId, status);
    }

    public String getThreadMessagesRSS(long threadId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        String name = "";
        String description = "";
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        MBThread thread = this._mbThreadLocalService.getThread(threadId);
        if (this._messageModelResourcePermission.contains(this.getPermissionChecker(), thread.getRootMessageId(), "VIEW")) {
            MessageCreateDateComparator comparator = MessageCreateDateComparator.getInstance((boolean)false);
            List threadMessages = this.mbMessageLocalService.getThreadMessages(threadId, status, (Comparator)comparator);
            for (MBMessage message : threadMessages) {
                if (messages.size() >= max) break;
                if (!this._messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) continue;
                messages.add(message);
            }
            if (!messages.isEmpty()) {
                MBMessage message = (MBMessage)messages.get(messages.size() - 1);
                name = message.getSubject();
                description = message.getSubject();
            }
        }
        return this._exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public void moveMessageAttachmentToTrash(long messageId, String fileName) throws PortalException {
        this._messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "UPDATE");
        this.mbMessageLocalService.moveMessageAttachmentToTrash(this.getUserId(), messageId, fileName);
    }

    public void restoreMessageAttachmentFromTrash(long messageId, String fileName) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)message.getGroupId(), (long)message.getCategoryId(), (String)"ADD_FILE");
        this.mbMessageLocalService.restoreMessageAttachmentFromTrash(this.getUserId(), messageId, fileName);
    }

    public void subscribeMessage(long messageId) throws PortalException {
        this._messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "SUBSCRIBE");
        this.mbMessageLocalService.subscribeMessage(this.getUserId(), messageId);
    }

    public void unsubscribeMessage(long messageId) throws PortalException {
        this._messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "SUBSCRIBE");
        this.mbMessageLocalService.unsubscribeMessage(this.getUserId(), messageId);
    }

    public MBMessage updateAnswer(long messageId, boolean answer, boolean cascade) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this._messageModelResourcePermission.check(this.getPermissionChecker(), message.getRootMessageId(), "UPDATE");
        return this.mbMessageLocalService.updateAnswer(messageId, answer, cascade);
    }

    public MBMessage updateDiscussionMessage(String className, long classPK, long messageId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        this._discussionPermission.checkUpdatePermission(this.getPermissionChecker(), messageId);
        return this.mbMessageLocalService.updateDiscussionMessage(this.getUserId(), messageId, className, classPK, subject, body, serviceContext);
    }

    public MBMessage updateMessage(long messageId, String subject, String body, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        boolean preview = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"preview");
        if (preview && this._messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "UPDATE")) {
            this._checkReplyToPermission(message.getGroupId(), message.getCategoryId(), message.getParentMessageId());
        } else {
            this._messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "UPDATE");
        }
        if (this._lockManager.isLocked(MBThread.class.getName(), message.getThreadId())) {
            throw new LockedThreadException(StringBundler.concat((Object[])new Object[]{"Thread is locked for class name ", MBThread.class.getName(), " and class PK ", message.getThreadId()}));
        }
        if (!ModelResourcePermissionUtil.contains(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)message.getGroupId(), (long)message.getCategoryId(), (String)"ADD_FILE")) {
            inputStreamOVPs = Collections.emptyList();
        }
        if (!ModelResourcePermissionUtil.contains(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)message.getGroupId(), (long)message.getCategoryId(), (String)"UPDATE_THREAD_PRIORITY")) {
            MBThread thread = this._mbThreadLocalService.getThread(message.getThreadId());
            priority = thread.getPriority();
        }
        return this.mbMessageLocalService.updateMessage(this.getGuestOrUserId(), messageId, subject, body, inputStreamOVPs, priority, allowPingbacks, serviceContext);
    }

    private void _checkReplyToPermission(long groupId, long categoryId, long parentMessageId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentMessageId > 0L) {
            if (ModelResourcePermissionUtil.contains(this._categoryModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)categoryId, (String)"ADD_MESSAGE")) {
                return;
            }
            if (!ModelResourcePermissionUtil.contains(this._categoryModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)categoryId, (String)"REPLY_TO_MESSAGE")) {
                throw new PrincipalException.MustHavePermission(permissionChecker, MBCategory.class.getName(), categoryId, new String[]{"REPLY_TO_MESSAGE"});
            }
        } else {
            ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)categoryId, (String)"ADD_MESSAGE");
        }
    }

    private String _exportToRSS(String name, String description, String type, double version, String displayStyle, String feedURL, String entryURL, List<MBMessage> messages, ThemeDisplay themeDisplay) {
        SyndFeed syndFeed = this._syndModelFactory.createSyndFeed();
        syndFeed.setDescription(description);
        ArrayList<SyndEntry> syndEntries = new ArrayList<SyndEntry>();
        syndFeed.setEntries(syndEntries);
        for (MBMessage message : messages) {
            SyndEntry syndEntry = this._syndModelFactory.createSyndEntry();
            if (message.isAnonymous()) {
                syndEntry.setAuthor(this._language.get(themeDisplay.getLocale(), "anonymous"));
            } else {
                syndEntry.setAuthor(this._portal.getUserName((BaseModel)message));
            }
            SyndContent syndContent = this._syndModelFactory.createSyndContent();
            syndContent.setType("html");
            String value = null;
            if (displayStyle.equals("abstract")) {
                value = StringUtil.shorten((String)this._htmlParser.extractText(message.getBody()), (int)PropsValues.MESSAGE_BOARDS_RSS_ABSTRACT_LENGTH, (String)"");
            } else if (displayStyle.equals("title")) {
                value = "";
            } else if (message.isFormatBBCode()) {
                value = BBCodeTranslatorUtil.getHTML((String)message.getBody());
                value = MBUtil.replaceMessageBodyPaths(themeDisplay, value);
            } else {
                value = message.getBody();
            }
            syndContent.setValue(value);
            syndEntry.setDescription(syndContent);
            String link = entryURL + "&messageId=" + message.getMessageId();
            syndEntry.setLink(link);
            syndEntry.setPublishedDate(message.getCreateDate());
            syndEntry.setTitle(message.getSubject());
            syndEntry.setUpdatedDate(message.getModifiedDate());
            syndEntry.setUri(link);
            syndEntries.add(syndEntry);
        }
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        ArrayList<SyndLink> syndLinks = new ArrayList<SyndLink>();
        syndFeed.setLinks(syndLinks);
        SyndLink selfSyndLink = this._syndModelFactory.createSyndLink();
        syndLinks.add(selfSyndLink);
        selfSyndLink.setHref(feedURL);
        selfSyndLink.setRel("self");
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(name);
        syndFeed.setUri(feedURL);
        return this._rssExporter.export(syndFeed);
    }
}

