/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.message.boards.model.impl;

import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.service.MBDiscussionLocalServiceUtil;

/**
 * The extended model base implementation for the MBDiscussion service. Represents a row in the &quot;MBDiscussion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MBDiscussionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see MBDiscussionImpl
 * @see MBDiscussion
 * @generated
 */
public abstract class MBDiscussionBaseImpl
	extends MBDiscussionModelImpl implements MBDiscussion {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a message boards discussion model instance should use the <code>MBDiscussion</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			MBDiscussionLocalServiceUtil.addMBDiscussion(this);
		}
		else {
			MBDiscussionLocalServiceUtil.updateMBDiscussion(this);
		}
	}

}