/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.message.boards.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.MBThreadModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the MBThread service. Represents a row in the &quot;MBThread&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>MBThreadModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MBThreadImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see MBThreadImpl
 * @generated
 */
@JSON(strict = true)
public class MBThreadModelImpl
	extends BaseModelImpl<MBThread> implements MBThreadModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a message boards thread model instance should use the <code>MBThread</code> interface instead.
	 */
	public static final String TABLE_NAME = "MBThread";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"threadId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"categoryId", Types.BIGINT}, {"rootMessageId", Types.BIGINT},
		{"rootMessageUserId", Types.BIGINT}, {"title", Types.VARCHAR},
		{"lastPostByUserId", Types.BIGINT}, {"lastPostDate", Types.TIMESTAMP},
		{"priority", Types.DOUBLE}, {"question", Types.BOOLEAN},
		{"lastPublishDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("threadId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("categoryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("rootMessageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("rootMessageUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPostByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("lastPostDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("question", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table MBThread (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,threadId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,categoryId LONG,rootMessageId LONG,rootMessageUserId LONG,title VARCHAR(255) null,lastPostByUserId LONG,lastPostDate DATE null,priority DOUBLE,question BOOLEAN,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (threadId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table MBThread";

	public static final String ORDER_BY_JPQL =
		" ORDER BY mbThread.priority DESC, mbThread.lastPostDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY MBThread.priority DESC, MBThread.lastPostDate DESC";

	public static final String ORDER_BY_SQL_INLINE_DISTINCT =
		" ORDER BY mbThread.priority DESC, mbThread.lastPostDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CATEGORYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LASTPOSTDATE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PRIORITY_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ROOTMESSAGEID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public MBThreadModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _threadId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setThreadId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _threadId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return MBThread.class;
	}

	@Override
	public String getModelClassName() {
		return MBThread.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<MBThread, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<MBThread, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MBThread, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((MBThread)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<MBThread, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<MBThread, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(MBThread)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<MBThread, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<MBThread, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<MBThread, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<MBThread, Object>> attributeGetterFunctions =
				new LinkedHashMap<String, Function<MBThread, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", MBThread::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", MBThread::getCtCollectionId);
			attributeGetterFunctions.put("uuid", MBThread::getUuid);
			attributeGetterFunctions.put("threadId", MBThread::getThreadId);
			attributeGetterFunctions.put("groupId", MBThread::getGroupId);
			attributeGetterFunctions.put("companyId", MBThread::getCompanyId);
			attributeGetterFunctions.put("userId", MBThread::getUserId);
			attributeGetterFunctions.put("userName", MBThread::getUserName);
			attributeGetterFunctions.put("createDate", MBThread::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", MBThread::getModifiedDate);
			attributeGetterFunctions.put("categoryId", MBThread::getCategoryId);
			attributeGetterFunctions.put(
				"rootMessageId", MBThread::getRootMessageId);
			attributeGetterFunctions.put(
				"rootMessageUserId", MBThread::getRootMessageUserId);
			attributeGetterFunctions.put("title", MBThread::getTitle);
			attributeGetterFunctions.put(
				"lastPostByUserId", MBThread::getLastPostByUserId);
			attributeGetterFunctions.put(
				"lastPostDate", MBThread::getLastPostDate);
			attributeGetterFunctions.put("priority", MBThread::getPriority);
			attributeGetterFunctions.put("question", MBThread::getQuestion);
			attributeGetterFunctions.put(
				"lastPublishDate", MBThread::getLastPublishDate);
			attributeGetterFunctions.put("status", MBThread::getStatus);
			attributeGetterFunctions.put(
				"statusByUserId", MBThread::getStatusByUserId);
			attributeGetterFunctions.put(
				"statusByUserName", MBThread::getStatusByUserName);
			attributeGetterFunctions.put("statusDate", MBThread::getStatusDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<MBThread, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<MBThread, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<MBThread, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<MBThread, Long>)MBThread::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<MBThread, Long>)MBThread::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid", (BiConsumer<MBThread, String>)MBThread::setUuid);
			attributeSetterBiConsumers.put(
				"threadId", (BiConsumer<MBThread, Long>)MBThread::setThreadId);
			attributeSetterBiConsumers.put(
				"groupId", (BiConsumer<MBThread, Long>)MBThread::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<MBThread, Long>)MBThread::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId", (BiConsumer<MBThread, Long>)MBThread::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<MBThread, String>)MBThread::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<MBThread, Date>)MBThread::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<MBThread, Date>)MBThread::setModifiedDate);
			attributeSetterBiConsumers.put(
				"categoryId",
				(BiConsumer<MBThread, Long>)MBThread::setCategoryId);
			attributeSetterBiConsumers.put(
				"rootMessageId",
				(BiConsumer<MBThread, Long>)MBThread::setRootMessageId);
			attributeSetterBiConsumers.put(
				"rootMessageUserId",
				(BiConsumer<MBThread, Long>)MBThread::setRootMessageUserId);
			attributeSetterBiConsumers.put(
				"title", (BiConsumer<MBThread, String>)MBThread::setTitle);
			attributeSetterBiConsumers.put(
				"lastPostByUserId",
				(BiConsumer<MBThread, Long>)MBThread::setLastPostByUserId);
			attributeSetterBiConsumers.put(
				"lastPostDate",
				(BiConsumer<MBThread, Date>)MBThread::setLastPostDate);
			attributeSetterBiConsumers.put(
				"priority",
				(BiConsumer<MBThread, Double>)MBThread::setPriority);
			attributeSetterBiConsumers.put(
				"question",
				(BiConsumer<MBThread, Boolean>)MBThread::setQuestion);
			attributeSetterBiConsumers.put(
				"lastPublishDate",
				(BiConsumer<MBThread, Date>)MBThread::setLastPublishDate);
			attributeSetterBiConsumers.put(
				"status", (BiConsumer<MBThread, Integer>)MBThread::setStatus);
			attributeSetterBiConsumers.put(
				"statusByUserId",
				(BiConsumer<MBThread, Long>)MBThread::setStatusByUserId);
			attributeSetterBiConsumers.put(
				"statusByUserName",
				(BiConsumer<MBThread, String>)MBThread::setStatusByUserName);
			attributeSetterBiConsumers.put(
				"statusDate",
				(BiConsumer<MBThread, Date>)MBThread::setStatusDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getThreadId() {
		return _threadId;
	}

	@Override
	public void setThreadId(long threadId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_threadId = threadId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCategoryId() {
		return _categoryId;
	}

	@Override
	public void setCategoryId(long categoryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_categoryId = categoryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCategoryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("categoryId"));
	}

	@JSON
	@Override
	public long getRootMessageId() {
		return _rootMessageId;
	}

	@Override
	public void setRootMessageId(long rootMessageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_rootMessageId = rootMessageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalRootMessageId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("rootMessageId"));
	}

	@JSON
	@Override
	public long getRootMessageUserId() {
		return _rootMessageUserId;
	}

	@Override
	public void setRootMessageUserId(long rootMessageUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_rootMessageUserId = rootMessageUserId;
	}

	@Override
	public String getRootMessageUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(
				getRootMessageUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setRootMessageUserUuid(String rootMessageUserUuid) {
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	@JSON
	@Override
	public long getLastPostByUserId() {
		return _lastPostByUserId;
	}

	@Override
	public void setLastPostByUserId(long lastPostByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPostByUserId = lastPostByUserId;
	}

	@Override
	public String getLastPostByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getLastPostByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setLastPostByUserUuid(String lastPostByUserUuid) {
	}

	@JSON
	@Override
	public Date getLastPostDate() {
		return _lastPostDate;
	}

	@Override
	public void setLastPostDate(Date lastPostDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPostDate = lastPostDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalLastPostDate() {
		return getColumnOriginalValue("lastPostDate");
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public double getOriginalPriority() {
		return GetterUtil.getDouble(
			this.<Double>getColumnOriginalValue("priority"));
	}

	@JSON
	@Override
	public boolean getQuestion() {
		return _question;
	}

	@JSON
	@Override
	public boolean isQuestion() {
		return _question;
	}

	@Override
	public void setQuestion(boolean question) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_question = question;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public long getContainerModelId() {
		return getThreadId();
	}

	@Override
	public void setContainerModelId(long containerModelId) {
		_threadId = containerModelId;
	}

	@Override
	public long getParentContainerModelId() {
		return getCategoryId();
	}

	@Override
	public void setParentContainerModelId(long parentContainerModelId) {
		_categoryId = parentContainerModelId;
	}

	@Override
	public String getContainerModelName() {
		return String.valueOf(getTitle());
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(MBThread.class.getName()));
	}

	@Override
	public long getTrashEntryClassPK() {
		return getPrimaryKey();
	}

	@Override
	public boolean isInTrash() {
		if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), MBThread.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public MBThread toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, MBThread>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		MBThreadImpl mbThreadImpl = new MBThreadImpl();

		mbThreadImpl.setMvccVersion(getMvccVersion());
		mbThreadImpl.setCtCollectionId(getCtCollectionId());
		mbThreadImpl.setUuid(getUuid());
		mbThreadImpl.setThreadId(getThreadId());
		mbThreadImpl.setGroupId(getGroupId());
		mbThreadImpl.setCompanyId(getCompanyId());
		mbThreadImpl.setUserId(getUserId());
		mbThreadImpl.setUserName(getUserName());
		mbThreadImpl.setCreateDate(getCreateDate());
		mbThreadImpl.setModifiedDate(getModifiedDate());
		mbThreadImpl.setCategoryId(getCategoryId());
		mbThreadImpl.setRootMessageId(getRootMessageId());
		mbThreadImpl.setRootMessageUserId(getRootMessageUserId());
		mbThreadImpl.setTitle(getTitle());
		mbThreadImpl.setLastPostByUserId(getLastPostByUserId());
		mbThreadImpl.setLastPostDate(getLastPostDate());
		mbThreadImpl.setPriority(getPriority());
		mbThreadImpl.setQuestion(isQuestion());
		mbThreadImpl.setLastPublishDate(getLastPublishDate());
		mbThreadImpl.setStatus(getStatus());
		mbThreadImpl.setStatusByUserId(getStatusByUserId());
		mbThreadImpl.setStatusByUserName(getStatusByUserName());
		mbThreadImpl.setStatusDate(getStatusDate());

		mbThreadImpl.resetOriginalValues();

		return mbThreadImpl;
	}

	@Override
	public MBThread cloneWithOriginalValues() {
		MBThreadImpl mbThreadImpl = new MBThreadImpl();

		mbThreadImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		mbThreadImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		mbThreadImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		mbThreadImpl.setThreadId(this.<Long>getColumnOriginalValue("threadId"));
		mbThreadImpl.setGroupId(this.<Long>getColumnOriginalValue("groupId"));
		mbThreadImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		mbThreadImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		mbThreadImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		mbThreadImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		mbThreadImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		mbThreadImpl.setCategoryId(
			this.<Long>getColumnOriginalValue("categoryId"));
		mbThreadImpl.setRootMessageId(
			this.<Long>getColumnOriginalValue("rootMessageId"));
		mbThreadImpl.setRootMessageUserId(
			this.<Long>getColumnOriginalValue("rootMessageUserId"));
		mbThreadImpl.setTitle(this.<String>getColumnOriginalValue("title"));
		mbThreadImpl.setLastPostByUserId(
			this.<Long>getColumnOriginalValue("lastPostByUserId"));
		mbThreadImpl.setLastPostDate(
			this.<Date>getColumnOriginalValue("lastPostDate"));
		mbThreadImpl.setPriority(
			this.<Double>getColumnOriginalValue("priority"));
		mbThreadImpl.setQuestion(
			this.<Boolean>getColumnOriginalValue("question"));
		mbThreadImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		mbThreadImpl.setStatus(this.<Integer>getColumnOriginalValue("status"));
		mbThreadImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		mbThreadImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		mbThreadImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return mbThreadImpl;
	}

	@Override
	public int compareTo(MBThread mbThread) {
		int value = 0;

		if (getPriority() < mbThread.getPriority()) {
			value = -1;
		}
		else if (getPriority() > mbThread.getPriority()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		value = DateUtil.compareTo(
			getLastPostDate(), mbThread.getLastPostDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof MBThread)) {
			return false;
		}

		MBThread mbThread = (MBThread)object;

		long primaryKey = mbThread.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<MBThread> toCacheModel() {
		MBThreadCacheModel mbThreadCacheModel = new MBThreadCacheModel();

		mbThreadCacheModel.mvccVersion = getMvccVersion();

		mbThreadCacheModel.ctCollectionId = getCtCollectionId();

		mbThreadCacheModel.uuid = getUuid();

		String uuid = mbThreadCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			mbThreadCacheModel.uuid = null;
		}

		mbThreadCacheModel.threadId = getThreadId();

		mbThreadCacheModel.groupId = getGroupId();

		mbThreadCacheModel.companyId = getCompanyId();

		mbThreadCacheModel.userId = getUserId();

		mbThreadCacheModel.userName = getUserName();

		String userName = mbThreadCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			mbThreadCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			mbThreadCacheModel.createDate = createDate.getTime();
		}
		else {
			mbThreadCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			mbThreadCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			mbThreadCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		mbThreadCacheModel.categoryId = getCategoryId();

		mbThreadCacheModel.rootMessageId = getRootMessageId();

		mbThreadCacheModel.rootMessageUserId = getRootMessageUserId();

		mbThreadCacheModel.title = getTitle();

		String title = mbThreadCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			mbThreadCacheModel.title = null;
		}

		mbThreadCacheModel.lastPostByUserId = getLastPostByUserId();

		Date lastPostDate = getLastPostDate();

		if (lastPostDate != null) {
			mbThreadCacheModel.lastPostDate = lastPostDate.getTime();
		}
		else {
			mbThreadCacheModel.lastPostDate = Long.MIN_VALUE;
		}

		mbThreadCacheModel.priority = getPriority();

		mbThreadCacheModel.question = isQuestion();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			mbThreadCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			mbThreadCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		mbThreadCacheModel.status = getStatus();

		mbThreadCacheModel.statusByUserId = getStatusByUserId();

		mbThreadCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = mbThreadCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			mbThreadCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			mbThreadCacheModel.statusDate = statusDate.getTime();
		}
		else {
			mbThreadCacheModel.statusDate = Long.MIN_VALUE;
		}

		return mbThreadCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<MBThread, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<MBThread, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MBThread, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((MBThread)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, MBThread>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					MBThread.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _threadId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _categoryId;
	private long _rootMessageId;
	private long _rootMessageUserId;
	private String _title;
	private long _lastPostByUserId;
	private Date _lastPostDate;
	private double _priority;
	private boolean _question;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<MBThread, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((MBThread)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("threadId", _threadId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("categoryId", _categoryId);
		_columnOriginalValues.put("rootMessageId", _rootMessageId);
		_columnOriginalValues.put("rootMessageUserId", _rootMessageUserId);
		_columnOriginalValues.put("title", _title);
		_columnOriginalValues.put("lastPostByUserId", _lastPostByUserId);
		_columnOriginalValues.put("lastPostDate", _lastPostDate);
		_columnOriginalValues.put("priority", _priority);
		_columnOriginalValues.put("question", _question);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("threadId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("categoryId", 1024L);

		columnBitmasks.put("rootMessageId", 2048L);

		columnBitmasks.put("rootMessageUserId", 4096L);

		columnBitmasks.put("title", 8192L);

		columnBitmasks.put("lastPostByUserId", 16384L);

		columnBitmasks.put("lastPostDate", 32768L);

		columnBitmasks.put("priority", 65536L);

		columnBitmasks.put("question", 131072L);

		columnBitmasks.put("lastPublishDate", 262144L);

		columnBitmasks.put("status", 524288L);

		columnBitmasks.put("statusByUserId", 1048576L);

		columnBitmasks.put("statusByUserName", 2097152L);

		columnBitmasks.put("statusDate", 4194304L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private MBThread _escapedModel;

}